"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MBMap = void 0;
var _reactRedux = require("react-redux");
var _mb_map = require("./mb_map");
var _actions = require("../../actions");
var _map_selectors = require("../../selectors/map_selectors");
var _ui_selectors = require("../../selectors/ui_selectors");
var _non_serializable_instances = require("../../reducers/non_serializable_instances");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isMapReady: (0, _map_selectors.getMapReady)(state),
    settings: (0, _map_selectors.getMapSettings)(state),
    customIcons: (0, _map_selectors.getCustomIcons)(state),
    layerList: (0, _map_selectors.getLayerList)(state),
    spatialFiltersLayer: (0, _map_selectors.getSpatialFiltersLayer)(state),
    goto: (0, _map_selectors.getGoto)(state),
    inspectorAdapters: (0, _non_serializable_instances.getInspectorAdapters)(state),
    isFullScreen: (0, _ui_selectors.getIsFullScreen)(state),
    timeslice: (0, _map_selectors.getTimeslice)(state),
    featureModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_SHAPES || (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_POINTS,
    filterModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_FILTERS,
    onMapMove: (0, _non_serializable_instances.getOnMapMove)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    extentChanged: mapExtentState => {
      dispatch((0, _actions.mapExtentChanged)(mapExtentState));
    },
    onMapReady: mapExtentState => {
      dispatch((0, _actions.clearGoto)());
      dispatch((0, _actions.mapExtentChanged)(mapExtentState));
      dispatch((0, _actions.mapReady)());
    },
    onMapDestroyed: () => {
      dispatch((0, _actions.mapDestroyed)());
    },
    setMouseCoordinates: ({
      lat,
      lon
    }) => {
      dispatch((0, _actions.setMouseCoordinates)({
        lat,
        lon
      }));
    },
    clearMouseCoordinates: () => {
      dispatch((0, _actions.clearMouseCoordinates)());
    },
    clearGoto: () => {
      dispatch((0, _actions.clearGoto)());
    },
    setMapInitError(errorMessage) {
      dispatch((0, _actions.setMapInitError)(errorMessage));
    }
  };
}
const connected = exports.MBMap = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_mb_map.MbMap);