"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esTopHitsLayerWizardConfig = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _create_source_editor = require("./create_source_editor");
var _vector_layer = require("../../../layers/vector_layer");
var _constants = require("../../../../../common/constants");
var _top_hits_layer_icon = require("../../../layers/wizards/icons/top_hits_layer_icon");
var _es_search_source = require("../es_search_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esTopHitsLayerWizardConfig = exports.esTopHitsLayerWizardConfig = {
  id: _constants.WIZARD_ID.ES_TOP_HITS,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.source.topHitsDescription', {
    defaultMessage: 'Display the most relevant documents per entity, e.g. the most recent GPS hits per vehicle.'
  }),
  icon: _top_hits_layer_icon.TopHitsLayerIcon,
  renderWizard: ({
    previewLayers,
    mapColors
  }) => {
    const onSourceConfigChange = (sourceConfig, isPointsOnly) => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const sourceDescriptor = _es_search_source.ESSearchSource.createDescriptor(sourceConfig);
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor
      }, mapColors);
      if (isPointsOnly) {
        layerDescriptor.style.properties[_constants.VECTOR_STYLES.LINE_WIDTH] = {
          type: _constants.STYLE_TYPE.STATIC,
          options: {
            size: 0
          }
        };
      }
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      onSourceConfigChange: onSourceConfigChange
    });
  },
  title: _i18n.i18n.translate('xpack.maps.source.topHitsTitle', {
    defaultMessage: 'Top hits per entity'
  })
};