"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initLogEntriesSummaryRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _http_api = require("../../../common/http_api");
var _runtime_types = require("../../../common/runtime_types");
var _serialized_query = require("../../utils/serialized_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const escapeHatch = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const initLogEntriesSummaryRoute = ({
  framework,
  logEntries,
  getUsageCollector
}) => {
  framework.registerVersionedRoute({
    access: 'internal',
    method: 'post',
    path: _http_api.logEntriesV1.LOG_ENTRIES_SUMMARY_PATH
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: escapeHatch
      }
    },
    options: {
      deprecated: {
        documentationUrl: '',
        severity: 'warning',
        message: _i18n.i18n.translate('xpack.logsShared.deprecations.postLogEntriesSummaryRoute.message', {
          defaultMessage: 'Given the deprecation of the LogStream feature, this API will not return reliable data in upcoming versions of Kibana.'
        }),
        reason: {
          type: 'deprecate'
        }
      }
    }
  }, async (requestContext, request, response) => {
    const payload = (0, _pipeable.pipe)(_http_api.logEntriesV1.logEntriesSummaryRequestRT.decode(request.body), (0, _Either.fold)((0, _runtime_types.throwErrors)(_boom.default.badRequest), _function.identity));
    const {
      logView,
      startTimestamp,
      endTimestamp,
      bucketSize,
      query
    } = payload;
    const usageCollector = getUsageCollector();
    const buckets = await logEntries.getLogSummaryBucketsBetween(requestContext, logView, startTimestamp, endTimestamp, bucketSize, (0, _serialized_query.parseFilterQuery)(query));
    if (typeof usageCollector.countLogs === 'function') {
      usageCollector.countLogs();
    }
    return response.ok({
      body: _http_api.logEntriesV1.logEntriesSummaryResponseRT.encode({
        data: {
          start: startTimestamp,
          end: endTimestamp,
          buckets
        }
      })
    });
  });
};
exports.initLogEntriesSummaryRoute = initLogEntriesSummaryRoute;