"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initLogsSharedServer = void 0;
var _log_entries = require("./routes/log_entries");
var _log_views = require("./routes/log_views");
var _deprecations = require("./routes/deprecations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initLogsSharedServer = libs => {
  (0, _log_entries.initLogEntriesHighlightsRoute)(libs);
  (0, _log_entries.initLogEntriesSummaryRoute)(libs);
  (0, _log_entries.initLogEntriesSummaryHighlightsRoute)(libs);
  (0, _log_views.initLogViewRoutes)(libs);
  (0, _deprecations.initMigrateLogViewSettingsRoute)(libs);
};
exports.initLogsSharedServer = initLogsSharedServer;