"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useControlPanels = void 0;
var _unifiedFieldList = require("@kbn/unified-field-list");
var _react = require("@xstate/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useControlPanels = (logsExplorerControllerStateService, data) => {
  const {
    query,
    filters,
    fromDate,
    toDate
  } = (0, _unifiedFieldList.useQuerySubscriber)({
    data
  });
  const timeRange = {
    from: fromDate,
    to: toDate
  };
  const controlPanels = (0, _react.useSelector)(logsExplorerControllerStateService, state => {
    if (!('controlPanels' in state.context)) return;
    return state.context.controlPanels;
  });
  const getInitialState = (0, _react2.useCallback)(async initialState => {
    const state = {
      ...initialState,
      initialChildControlState: controlPanels !== null && controlPanels !== void 0 ? controlPanels : initialState.initialChildControlState
    };
    return {
      initialState: state
    };
  }, [controlPanels]);
  const setControlGroupAPI = (0, _react2.useCallback)(controlGroupAPI => {
    if (controlGroupAPI) logsExplorerControllerStateService.send({
      type: 'INITIALIZE_CONTROL_GROUP_API',
      controlGroupAPI
    });
  }, [logsExplorerControllerStateService]);
  return {
    getInitialState,
    setControlGroupAPI,
    query,
    filters,
    timeRange
  };
};
exports.useControlPanels = useControlPanels;