"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRoutesAuthorization = exports.useAuthorization = void 0;
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAuthorization = () => {
  const {
    capabilities
  } = (0, _use_kibana.useKibana)().services.application;
  const {
    fleet: integrations,
    fleetv2: fleet,
    actions
  } = capabilities;
  return {
    canCreateIntegrations: Boolean((fleet === null || fleet === void 0 ? void 0 : fleet.all) && (integrations === null || integrations === void 0 ? void 0 : integrations.all)),
    canExecuteConnectors: Boolean((actions === null || actions === void 0 ? void 0 : actions.show) && (actions === null || actions === void 0 ? void 0 : actions.execute)),
    canCreateConnectors: Boolean(actions === null || actions === void 0 ? void 0 : actions.save)
  };
};
exports.useAuthorization = useAuthorization;
const useRoutesAuthorization = () => {
  const {
    canCreateIntegrations,
    canExecuteConnectors
  } = useAuthorization();
  return {
    canUseIntegrationAssistant: canCreateIntegrations && canExecuteConnectors,
    canUseIntegrationUpload: canCreateIntegrations
  };
};
exports.useRoutesAuthorization = useRoutesAuthorization;