"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.breadcrumbService = exports.BreadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const homeBreadcrumbText = _i18n.i18n.translate('xpack.ingestPipelines.breadcrumb.pipelinesLabel', {
  defaultMessage: 'Ingest Pipelines'
});
class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      home: [{
        text: homeBreadcrumbText
      }],
      create: [{
        text: homeBreadcrumbText,
        href: `/`
      }, {
        text: _i18n.i18n.translate('xpack.ingestPipelines.breadcrumb.createPipelineLabel', {
          defaultMessage: 'Create pipeline'
        })
      }],
      edit: [{
        text: homeBreadcrumbText,
        href: `/`
      }, {
        text: _i18n.i18n.translate('xpack.ingestPipelines.breadcrumb.editPipelineLabel', {
          defaultMessage: 'Edit pipeline'
        })
      }],
      manage_processors: [{
        text: homeBreadcrumbText,
        href: `/`
      }, {
        text: _i18n.i18n.translate('xpack.ingestPipelines.breadcrumb.manageProcessorsLabel', {
          defaultMessage: 'Manage processors'
        })
      }]
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error('Breadcrumb service has not been initialized');
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
exports.BreadcrumbService = BreadcrumbService;
const breadcrumbService = exports.breadcrumbService = new BreadcrumbService();