"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricSparkline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _use_kibana_time_zone_setting = require("../../../../../hooks/use_kibana_time_zone_setting");
var _use_chart_themes = require("../../../../../hooks/use_chart_themes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timestampAccessor = 'timestamp';
const valueAccessor = ['value'];
const sparklineSize = {
  height: 20,
  width: 100
};
const SingleMetricSparkline = ({
  metric,
  timeRange
}) => {
  const timeZone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const {
    baseTheme,
    sparklineTheme
  } = (0, _use_chart_themes.useChartThemes)();
  const xDomain = (0, _react.useMemo)(() => ({
    max: timeRange.endTime,
    min: timeRange.startTime
  }), [timeRange]);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: sparklineSize
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    theme: sparklineTheme,
    baseTheme: baseTheme,
    xDomain: xDomain,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "metric",
    data: metric,
    xAccessor: timestampAccessor
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yAccessors: valueAccessor,
    timeZone: timeZone
  }));
};
exports.SingleMetricSparkline = SingleMetricSparkline;