"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesNodeCharts = exports.KubernetesContainerCharts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _i18n = require("@kbn/i18n");
var _use_host_metrics_charts = require("../hooks/use_host_metrics_charts");
var _section = require("../components/section");
var _section_title = require("../components/section_title");
var _translations = require("../translations");
var _constants = require("../constants");
var _charts_grid = require("../charts_grid/charts_grid");
var _chart = require("./chart");
var _use_integration_check = require("../hooks/use_integration_check");
var _use_container_metrics_charts = require("../hooks/use_container_metrics_charts");
var _constants2 = require("../../../common/visualizations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FRAGMENT_BASE = 'key-metrics';
const KubernetesNodeCharts = exports.KubernetesNodeCharts = /*#__PURE__*/_react.default.forwardRef(({
  assetId,
  dataView,
  dateRange,
  onShowAll,
  overview
}, ref) => {
  const {
    charts
  } = (0, _use_host_metrics_charts.useKubernetesCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    overview
  });
  const hasIntegration = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.kubernetesNode
  });
  if (!hasIntegration) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.SectionTitle, {
      title: _translations.HOST_METRIC_GROUP_TITLES.kubernetes
    }),
    "data-test-subj": "infraAssetDetailsKubernetesChartsSection",
    id: "kubernetes",
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.charts.kubernetes.showAllButton.ariaLabel', {
        defaultMessage: 'Show all Kubernetes charts'
      }),
      "data-test-subj": "infraAssetDetailsKubernetesChartsShowAllButton",
      onClick: () => onShowAll('kubernetes'),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.kubernetes.showAllButton",
      defaultMessage: "Show all"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    id: chart.id,
    key: chart.id,
    assetId: assetId,
    dateRange: dateRange,
    lensAttributes: chart,
    queryField: (0, _common.findInventoryFields)('host').id
  }))));
});
const KubernetesContainerCharts = exports.KubernetesContainerCharts = /*#__PURE__*/_react.default.forwardRef(({
  assetId,
  dataView,
  dateRange,
  metric,
  onShowAll
}, ref) => {
  const {
    charts
  } = (0, _use_container_metrics_charts.useK8sContainerPageViewMetricsCharts)({
    metric,
    metricsDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
      title: _translations.CONTAINER_METRIC_GROUP_TITLES[metric],
      tooltipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.charts.container.k8s.toolTip",
        defaultMessage: "See container-related {link} for more information",
        values: {
          link:
          /*#__PURE__*/
          // confirm the link, there's not documentation for k8s container metrics
          _react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "infraAssetDetailsViewContainerK8sMetricsDocumentationLink",
            href: `${_constants2.CONTAINER_METRICS_DOC_HREF}#${FRAGMENT_BASE}-${metric}`,
            target: "_blank",
            className: (0, _css.cx)({
              [(0, _css.css)`
                          text-transform: lowercase;
                        `]: metric !== 'cpu'
            })
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.infra.assetDetails.charts.container.k8s.toolTip.linkText",
            defaultMessage: "{metric} metrics",
            values: {
              metric: _translations.CONTAINER_METRIC_GROUP_TITLES[metric]
            }
          }))
        }
      }))
    }),
    "data-test-subj": `infraAssetDetailsK8ContainerChartsSection${metric}`,
    id: metric,
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.infra.kubernetesContainerCharts.showallButton.ariaLabel', {
        defaultMessage: 'Show all {metric} charts',
        values: {
          metric
        }
      }),
      "data-test-subj": "infraAssetDetailsKubernetesChartsShowAllButton",
      onClick: () => onShowAll(metric),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.kubernetes.showAllButton",
      defaultMessage: "Show all"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    id: chart.id,
    key: chart.id,
    lensAttributes: chart,
    assetId: assetId,
    dateRange: dateRange,
    queryField: (0, _common.findInventoryFields)('container').id
  }))));
});