"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorReporter = void 0;
var _Either = require("fp-ts/lib/Either");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const failure = validation => {
  return validation.map(e => {
    const path = [];
    let validationName = '';
    e.context.forEach((ctx, idx) => {
      if (ctx.key) {
        path.push(ctx.key);
      }
      if (idx === e.context.length - 1) {
        validationName = ctx.type.name;
      }
    });
    const lastItemName = path[path.length - 1];
    return {
      path,
      message: 'Invalid value ' + JSON.stringify(e.value) + ` supplied to ${lastItemName}(${validationName})`
    };
  });
};
const empty = [];
const success = () => empty;
const errorReporter = exports.errorReporter = {
  report: (0, _Either.fold)(failure, success)
};