"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MinAge = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n_texts = require("../../../edit_policy/i18n_texts");
var _action_description = require("./action_description");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MinAge = ({
  phase,
  phases
}) => {
  var _phases$phase;
  const minAge = (_phases$phase = phases[phase]) === null || _phases$phase === void 0 ? void 0 : _phases$phase.min_age;
  return minAge ? /*#__PURE__*/_react.default.createElement(_action_description.ActionDescription, {
    title: _i18n_texts.i18nTexts.editPolicy.minAgeLabel,
    descriptionItems: [`${minAge} ${_i18n_texts.i18nTexts.editPolicy.minAgeUnitFieldSuffix}`]
  }) : null;
};
exports.MinAge = MinAge;