"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataStreamId = useDataStreamId;
exports.useOutputs = useOutputs;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../../../../../../common/constants");
var _output_helpers = require("../../../../../../../../../common/services/output_helpers");
var _hooks = require("../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDataStreamId() {
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useMemo)(() => {
    var _searchParams$get;
    const searchParams = new URLSearchParams(history.location.search);
    return (_searchParams$get = searchParams.get('datastreamId')) !== null && _searchParams$get !== void 0 ? _searchParams$get : undefined;
  }, [history.location.search]);
}
function useOutputs(packagePolicy, packageName) {
  const licenseService = (0, _hooks.useLicense)();
  const canUseOutputPerIntegration = licenseService.hasAtLeast(_constants.LICENCE_FOR_OUTPUT_PER_INTEGRATION);
  const {
    data: outputsData,
    isLoading
  } = (0, _hooks.useGetOutputs)();
  const allowedOutputTypes = (0, _output_helpers.getAllowedOutputTypesForPackagePolicy)(packagePolicy);
  const allowedOutputs = (0, _react.useMemo)(() => {
    if (!outputsData || !canUseOutputPerIntegration) {
      return [];
    }
    return outputsData.items.filter(output => allowedOutputTypes.includes(output.type));
  }, [allowedOutputTypes, canUseOutputPerIntegration, outputsData]);
  return {
    isLoading,
    canUseOutputPerIntegration,
    allowedOutputs
  };
}