"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMPTY_LABEL = exports.CHOOSE_REPORT_DEFINITION = void 0;
exports.EmptyView = EmptyView;
exports.SELECT_REPORT_TYPE_BELOW = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _series_editor = require("../series_editor/series_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptyView({
  loading,
  series,
  reportType
}) {
  const {
    dataType,
    reportDefinitions
  } = series !== null && series !== void 0 ? series : {};
  let emptyMessage = EMPTY_LABEL;
  if (dataType) {
    if (reportType) {
      if ((0, _lodash.isEmpty)(reportDefinitions)) {
        emptyMessage = CHOOSE_REPORT_DEFINITION;
      }
    } else {
      emptyMessage = SELECT_REPORT_TYPE_BELOW;
    }
  } else {
    emptyMessage = SELECTED_DATA_TYPE_FOR_REPORT;
  }
  if (!series) {
    emptyMessage = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.notFound', {
      defaultMessage: 'No series found. Please add a series.'
    });
  }
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    style: {
      top: 'initial'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(FlexGroup, {
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, loading ? _series_editor.LOADING_VIEW : emptyMessage))));
}
const Wrapper = _styledComponents.default.div`
  text-align: center;
  position: relative;
`;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
`;
const EMPTY_LABEL = exports.EMPTY_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.emptyview', {
  defaultMessage: 'Nothing to display.'
});
const CHOOSE_REPORT_DEFINITION = exports.CHOOSE_REPORT_DEFINITION = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.emptyReportDefinition', {
  defaultMessage: 'Select a report definition to create a visualization.'
});
const SELECT_REPORT_TYPE_BELOW = exports.SELECT_REPORT_TYPE_BELOW = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.selectReportType.empty', {
  defaultMessage: 'Select a report type to create a visualization.'
});
const SELECTED_DATA_TYPE_FOR_REPORT = _i18n.i18n.translate('xpack.exploratoryView.expView.reportType.selectDataType', {
  defaultMessage: 'Select a data type to create a visualization.'
});