"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCrawlerMultipleSchedulesRoutes = registerCrawlerMultipleSchedulesRoutes;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _error_codes = require("../../../../common/types/error_codes");
var _fetch_crawler_multiple_schedules = require("../../../lib/crawler/fetch_crawler_multiple_schedules");
var _post_crawler_multiple_schedules = require("../../../lib/crawler/post_crawler_multiple_schedules");
var _create_error = require("../../../utils/create_error");
var _elasticsearch_error_handler = require("../../../utils/elasticsearch_error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCrawlerMultipleSchedulesRoutes({
  router,
  log
}) {
  router.post({
    path: '/internal/enterprise_search/indices/{indexName}/crawler/custom_scheduling',
    validate: {
      params: _configSchema.schema.object({
        indexName: _configSchema.schema.string()
      }),
      body: _configSchema.schema.mapOf(_configSchema.schema.string(), _configSchema.schema.object({
        name: _configSchema.schema.string(),
        interval: _configSchema.schema.string(),
        enabled: _configSchema.schema.boolean(),
        configurationOverrides: _configSchema.schema.object({
          maxCrawlDepth: _configSchema.schema.maybe(_configSchema.schema.number()),
          sitemapDiscoveryDisabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
          domainAllowlist: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
          sitemapUrls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
          seedUrls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
        })
      }))
    }
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      params,
      body
    } = request;
    await (0, _post_crawler_multiple_schedules.postCrawlerCustomScheduling)(client, params.indexName, body);
    return response.ok();
  }));
  router.get({
    path: '/internal/enterprise_search/indices/{indexName}/crawler/custom_scheduling',
    validate: {
      params: _configSchema.schema.object({
        indexName: _configSchema.schema.string()
      })
    }
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    try {
      const {
        params
      } = request;
      const customScheduling = await (0, _fetch_crawler_multiple_schedules.fetchCrawlerCustomSchedulingByIndexName)(client, params.indexName);
      return response.ok({
        body: customScheduling,
        headers: {
          'content-type': 'application/json'
        }
      });
    } catch (error) {
      if (error.message === _error_codes.ErrorCode.DOCUMENT_NOT_FOUND) {
        return (0, _create_error.createError)({
          errorCode: error.message,
          message: _i18n.i18n.translate('xpack.enterpriseSearch.server.routes.fetchCrawlerMultipleSchedules.documentNotFoundError', {
            defaultMessage: 'Crawler data could not be found.'
          }),
          response,
          statusCode: 404
        });
      }
      throw error;
    }
  }));
}