"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisplaySettingsRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _app_logic = require("../../../../app_logic");
var _routes = require("../../../../routes");
var _display_settings = require("./display_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DisplaySettingsRouter = () => {
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getSourcesPath)(_routes.DISPLAY_SETTINGS_SEARCH_RESULT_PATH, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_display_settings.DisplaySettings, {
    tabId: 0
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getSourcesPath)(_routes.DISPLAY_SETTINGS_RESULT_DETAIL_PATH, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_display_settings.DisplaySettings, {
    tabId: 1
  })));
};
exports.DisplaySettingsRouter = DisplaySettingsRouter;