"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _view_content_header = require("../view_content_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentSection = ({
  children,
  isOrganization = true,
  className = '',
  title,
  description,
  action,
  headerChildren,
  testSubj
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: className,
  "data-test-subj": testSubj
}, title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
  title: title,
  headingLevel: isOrganization ? 3 : 2,
  titleSize: "s",
  description: description,
  action: action
}), headerChildren), children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
exports.ContentSection = ContentSection;