"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MethodApi = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _api = require("../../../../../../common/types/api");
var _new_search_index_template = require("../new_search_index_template");
var _method_api_logic = require("./method_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MethodApi = () => {
  const {
    makeRequest
  } = (0, _kea.useActions)(_method_api_logic.MethodApiLogic);
  const {
    status
  } = (0, _kea.useValues)(_method_api_logic.MethodApiLogic);
  return /*#__PURE__*/_react.default.createElement(_new_search_index_template.NewSearchIndexTemplate, {
    type: "api",
    buttonLoading: status === _api.Status.LOADING,
    onSubmit: (indexName, language) => makeRequest({
      indexName,
      language
    })
  });
};
exports.MethodApi = MethodApi;