"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revertConnectorPipeline = exports.RevertConnectorPipelineApilogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const revertConnectorPipeline = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/pipelines`;
  return await _http.HttpLogic.values.http.delete(route);
};
exports.revertConnectorPipeline = revertConnectorPipeline;
const RevertConnectorPipelineApilogic = exports.RevertConnectorPipelineApilogic = (0, _create_api_logic.createApiLogic)(['revert_connector_pipeline_api'], revertConnectorPipeline);