"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../shared/doc_links");
var _flash_messages = require("../../../../shared/flash_messages");
var _generic_endpoint_inline_editable_table = require("../../../../shared/tables/generic_endpoint_inline_editable_table");
var _crawler_single_domain_logic = require("../crawler_single_domain_logic");
var _types = require("../types");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DESCRIPTION = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.description",
  defaultMessage: "Create a crawl rule to include or exclude pages whose URL matches the rule. Rules run in sequential order, and each URL is evaluated according to the first match. {link}",
  values: {
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "enterpriseSearchLearnMoreAboutCrawlRulesLink",
      href: _doc_links.docLinks.appSearchCrawlRules,
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.descriptionLinkText', {
      defaultMessage: 'Learn more about crawl rules'
    }))
  }
}));
const CrawlRulesTable = ({
  description = DEFAULT_DESCRIPTION,
  domainId,
  engineName,
  crawlRules,
  defaultCrawlRule
}) => {
  const {
    updateCrawlRules
  } = (0, _kea.useActions)(_crawler_single_domain_logic.CrawlerSingleDomainLogic);
  const columns = [{
    editingRender: (crawlRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "enterpriseSearchColumnsSelect",
      fullWidth: true,
      value: crawlRule.policy,
      hasNoInitialSelection: !crawlRule.policy,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      options: [_types.CrawlerPolicies.allow, _types.CrawlerPolicies.deny].map(policyOption => ({
        text: (0, _types.getReadableCrawlerPolicy)(policyOption),
        value: policyOption
      }))
    }),
    render: crawlRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _types.getReadableCrawlerPolicy)(crawlRule.policy)),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.policyTableHead', {
      defaultMessage: 'Policy'
    }),
    field: 'policy'
  }, {
    editingRender: (crawlRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "enterpriseSearchColumnsSelect",
      fullWidth: true,
      value: crawlRule.rule,
      hasNoInitialSelection: !crawlRule.rule,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      options: [_types.CrawlerRules.beginsWith, _types.CrawlerRules.endsWith, _types.CrawlerRules.contains, _types.CrawlerRules.regex].map(ruleOption => ({
        text: (0, _types.getReadableCrawlerRule)(ruleOption),
        value: ruleOption
      }))
    }),
    render: crawlRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _types.getReadableCrawlerRule)(crawlRule.rule)),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.ruleTableHead', {
      defaultMessage: 'Rule'
    }),
    field: 'rule'
  }, {
    editingRender: (crawlRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "enterpriseSearchColumnsFieldText",
      fullWidth: true,
      value: crawlRule.pattern,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: (0, _utils.getCrawlRulePathPatternTooltip)(crawlRule),
      type: "iInCircle",
      position: "top"
    }))),
    render: crawlRule => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, crawlRule.pattern),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.pathPatternTableHead', {
      defaultMessage: 'Path pattern'
    }),
    field: 'pattern'
  }];
  const crawlRulesRoute = `/internal/app_search/engines/${engineName}/crawler/domains/${domainId}/crawl_rules`;
  const domainRoute = `/internal/app_search/engines/${engineName}/crawler/domains/${domainId}`;
  const getCrawlRuleRoute = crawlRule => `/internal/app_search/engines/${engineName}/crawler/domains/${domainId}/crawl_rules/${crawlRule.id}`;
  return /*#__PURE__*/_react.default.createElement(_generic_endpoint_inline_editable_table.GenericEndpointInlineEditableTable, {
    addButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.addButtonLabel', {
      defaultMessage: 'Add crawl rule'
    }),
    columns: columns,
    description: description,
    instanceId: "CrawlRulesTable",
    items: crawlRules,
    addRoute: crawlRulesRoute,
    dataProperty: "crawl_rules",
    deleteRoute: getCrawlRuleRoute,
    updateRoute: getCrawlRuleRoute,
    reorderRoute: domainRoute,
    onAdd: (_, newCrawlRules) => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    onDelete: (_, newCrawlRules) => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
      (0, _flash_messages.flashSuccessToast)(_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.deleteSuccessToastMessage', {
        defaultMessage: 'The crawl rule has been deleted.'
      }));
    },
    onUpdate: (_, newCrawlRules) => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    onReorder: newCrawlRules => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.title', {
      defaultMessage: 'Crawl rules'
    }),
    uneditableItems: defaultCrawlRule ? [defaultCrawlRule] : undefined,
    canRemoveLastItem: true
  });
};
exports.CrawlRulesTable = CrawlRulesTable;