"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsList = exports.TagsCount = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
require("./tags.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TagsCount = ({
  tags
}) => {
  if (!(tags !== null && tags !== void 0 && tags.length)) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: tags.join(', ')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'hollow'
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.tagsCountBadge', {
    defaultMessage: '{tagsCount, plural, one {# tag} other {# tags}}',
    values: {
      tagsCount: tags.length
    }
  })));
};
exports.TagsCount = TagsCount;
const TagsList = ({
  tags
}) => {
  if (!(tags !== null && tags !== void 0 && tags.length)) return null;
  const displayedTags = tags.slice(0, 2);
  const tooltipTags = tags.slice(2);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    className: "tagsList"
  }, displayedTags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    key: tag
  }, tag)), tooltipTags.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: tooltipTags.join(', ')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.moreTagsBadge', {
    defaultMessage: 'and {moreTagsCount} more',
    values: {
      moreTagsCount: tooltipTags.length
    }
  }))));
};
exports.TagsList = TagsList;