"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoveriesWithOriginalValues = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDiscoveriesWithOriginalValues = ({
  attackDiscoveries,
  replacements
}) => attackDiscoveries.map(attackDiscovery => {
  var _attackDiscovery$enti;
  return {
    ...attackDiscovery,
    detailsMarkdown: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.detailsMarkdown,
      replacements
    }),
    entitySummaryMarkdown: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: (_attackDiscovery$enti = attackDiscovery.entitySummaryMarkdown) !== null && _attackDiscovery$enti !== void 0 ? _attackDiscovery$enti : '',
      replacements
    }),
    summaryMarkdown: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.summaryMarkdown,
      replacements
    }),
    title: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.title,
      replacements
    })
  };
});
exports.getDiscoveriesWithOriginalValues = getDiscoveriesWithOriginalValues;