"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSecurityRootProfileProvider = void 0;
var _profiles = require("../../../profiles");
var _get_cell_renderer_accessor = require("../accessors/get_cell_renderer_accessor");
var _get_default_app_state = require("../accessors/get_default_app_state");
var _get_row_indicator = require("../accessors/get_row_indicator");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createSecurityRootProfileProvider = services => {
  const {
    discoverShared
  } = services;
  const discoverFeaturesRegistry = discoverShared.features.registry;
  const cellRendererFeature = discoverFeaturesRegistry.getById('security-solution-cell-renderer');
  return {
    profileId: _constants.SECURITY_PROFILE_ID.root,
    profile: {
      getCellRenderers: (prev, {
        context
      }) => params => {
        const entries = prev(params);
        if (!params.dataView.getIndexPattern().includes(_constants.ALERTS_INDEX_PATTERN)) {
          return entries;
        }
        ['kibana.alert.workflow_status'].forEach(fieldName => {
          var _context$getSecurityS, _context$getSecurityS2;
          entries[fieldName] = (_context$getSecurityS = (_context$getSecurityS2 = context.getSecuritySolutionCellRenderer) === null || _context$getSecurityS2 === void 0 ? void 0 : _context$getSecurityS2.call(context, fieldName)) !== null && _context$getSecurityS !== void 0 ? _context$getSecurityS : entries[fieldName];
        });
        return entries;
      },
      getRowIndicatorProvider: () => () => _get_row_indicator.getAlertEventRowIndicator,
      getDefaultAppState: (0, _get_default_app_state.createDefaultSecuritySolutionAppStateGetter)()
    },
    resolve: async params => {
      if (params.solutionNavId !== _profiles.SolutionType.Security) {
        return {
          isMatch: false
        };
      }
      const getCellRenderer = await (0, _get_cell_renderer_accessor.createCellRendererAccessor)(cellRendererFeature);
      return {
        isMatch: true,
        context: {
          solutionType: _profiles.SolutionType.Security,
          getSecuritySolutionCellRenderer: getCellRenderer
        }
      };
    }
  };
};
exports.createSecurityRootProfileProvider = createSecurityRootProfileProvider;