"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocTableWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _discoverUtils = require("@kbn/discover-utils");
var _table_header = require("./components/table_header/table_header");
var _table_row = require("./components/table_row");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const wait = ms => new Promise(resolve => setTimeout(resolve, ms));
const DocTableWrapper = exports.DocTableWrapper = /*#__PURE__*/(0, _react.forwardRef)(({
  render,
  columns,
  filters,
  isEsqlMode,
  savedSearchId,
  rows,
  dataView,
  onSort,
  onAddColumn,
  onMoveColumn,
  onRemoveColumn,
  sort,
  onFilter,
  useNewFieldsApi,
  searchDescription,
  sharedItemTitle,
  dataTestSubj,
  isLoading
}, ref) => {
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const showMultiFields = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS, false), [uiSettings]);
  const onSkipBottomButtonClick = (0, _react.useCallback)(async () => {
    // delay scrolling to after the rows have been rendered
    const bottomMarker = document.getElementById('discoverBottomMarker');
    while (rows.length !== document.getElementsByClassName('kbnDocTable__row').length) {
      await wait(50);
    }
    bottomMarker.focus();
    await wait(50);
    bottomMarker.blur();
  }, [rows]);
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _discoverUtils.getShouldShowFieldHandler)(dataView.fields.map(field => field.name), dataView, showMultiFields), [dataView, showMultiFields]);
  const renderHeader = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_table_header.TableHeader, {
    columns: columns,
    dataView: dataView,
    onChangeSortOrder: onSort,
    onMoveColumn: onMoveColumn,
    onRemoveColumn: onRemoveColumn,
    sortOrder: sort
  }), [columns, dataView, onMoveColumn, onRemoveColumn, onSort, sort]);
  const renderRows = (0, _react.useCallback)(rowsToRender => {
    return rowsToRender.map(current => /*#__PURE__*/_react.default.createElement(_table_row.TableRow, {
      key: `${current.id}${current.raw._score}${current.raw._version}`,
      columns: columns,
      filters: filters,
      savedSearchId: savedSearchId,
      filter: onFilter,
      dataView: dataView,
      row: current,
      useNewFieldsApi: useNewFieldsApi,
      shouldShowFieldHandler: shouldShowFieldHandler,
      onAddColumn: onAddColumn,
      onRemoveColumn: onRemoveColumn,
      isEsqlMode: isEsqlMode,
      rows: rows
    }));
  }, [columns, filters, savedSearchId, onFilter, dataView, useNewFieldsApi, shouldShowFieldHandler, onAddColumn, onRemoveColumn, isEsqlMode, rows]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocTableWrapper eui-yScroll eui-xScroll",
    "data-shared-item": true,
    "data-title": sharedItemTitle,
    "data-description": searchDescription,
    "data-test-subj": dataTestSubj,
    "data-render-complete": !isLoading,
    ref: ref
  }, rows.length !== 0 && render({
    columnLength: columns.length,
    rows,
    onSkipBottomButtonClick,
    renderHeader,
    renderRows
  }), !rows.length && /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocTable__error"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.loadingResults",
    defaultMessage: "Loading results"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "discoverApp",
    size: "m",
    color: "subdued"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docTable.noResultsTitle",
    defaultMessage: "No results found"
  })))));
});