"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _helpers = require("../common/utils/helpers");
var _subscription = require("../common/utils/subscription");
var _setup_routes = require("./routes/setup_routes");
var _saved_objects = require("./saved_objects");
var _data_views = require("./saved_objects/data_views");
var _create_indices = require("./create_indices/create_indices");
var _create_transforms = require("./create_transforms/create_transforms");
var _fleet_integration = require("./fleet_integration/fleet_integration");
var _constants = require("../common/constants");
var _findings_stats_task = require("./tasks/findings_stats_task");
var _register = require("./lib/telemetry/collectors/register");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var _isInitialized = /*#__PURE__*/new WeakMap();
class CspPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    /**
     * CSP is initialized when the Fleet package is installed.
     * either directly after installation, or
     * when the plugin is started and a package is present.
     */
    _classPrivateFieldInitSpec(this, _isInitialized, false);
    this.logger = initializerContext.logger.get();
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    core.savedObjects.registerType(_saved_objects.cspBenchmarkRule);
    core.savedObjects.registerType(_saved_objects.cspSettings);
    (0, _setup_routes.setupRoutes)({
      core,
      logger: this.logger,
      isPluginInitialized: () => _classPrivateFieldGet(_isInitialized, this)
    });
    const coreStartServices = core.getStartServices();
    this.setupCspTasks(plugins.taskManager, coreStartServices, this.logger);
    (0, _register.registerCspmUsageCollector)(this.logger, coreStartServices, plugins.usageCollection);
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;
    return {};
  }
  start(core, plugins) {
    plugins.fleet.fleetSetupCompleted().then(async () => {
      const packageInfo = await plugins.fleet.packageService.asInternalUser.getInstallation(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME);

      // If package is installed we want to make sure all needed assets are installed
      if (packageInfo) {
        this.initialize(core, plugins.taskManager).catch(() => {});
      }
      plugins.fleet.registerExternalCallback('packagePolicyCreate', async packagePolicy => {
        var _packagePolicy$packag;
        const license = await plugins.licensing.getLicense();
        if ((0, _helpers.isCspPackage)((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name)) {
          if (!(0, _subscription.isSubscriptionAllowed)(this.isCloudEnabled, license)) {
            throw new Error('To use this feature you must upgrade your subscription or start a trial');
          }
          if (!isSingleEnabledInput(packagePolicy.inputs)) {
            throw new Error('Only one enabled input is allowed per policy');
          }
        }
        return packagePolicy;
      });
      plugins.fleet.registerExternalCallback('packagePolicyCreate', async (packagePolicy, soClient) => {
        var _packagePolicy$packag2;
        if ((0, _helpers.isCspPackage)((_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name)) {
          return (0, _helpers.cleanupCredentials)(packagePolicy);
        }
        return packagePolicy;
      });
      plugins.fleet.registerExternalCallback('packagePolicyUpdate', async (packagePolicy, soClient) => {
        var _packagePolicy$packag3;
        if ((0, _helpers.isCspPackage)((_packagePolicy$packag3 = packagePolicy.package) === null || _packagePolicy$packag3 === void 0 ? void 0 : _packagePolicy$packag3.name)) {
          return (0, _helpers.cleanupCredentials)(packagePolicy);
        }
        return packagePolicy;
      });
      plugins.fleet.registerExternalCallback('packagePolicyPostCreate', async (packagePolicy, soClient) => {
        var _packagePolicy$packag4;
        if ((0, _helpers.isCspPackage)((_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name)) {
          await this.initialize(core, plugins.taskManager);
          return packagePolicy;
        }
        return packagePolicy;
      });
      plugins.fleet.registerExternalCallback('packagePolicyPostDelete', async deletedPackagePolicies => {
        for (const deletedPackagePolicy of deletedPackagePolicies) {
          var _deletedPackagePolicy;
          if ((0, _helpers.isCspPackage)((_deletedPackagePolicy = deletedPackagePolicy.package) === null || _deletedPackagePolicy === void 0 ? void 0 : _deletedPackagePolicy.name)) {
            const soClient = core.savedObjects.createInternalRepository();
            const packagePolicyService = plugins.fleet.packagePolicyService;
            const isPackageExists = await (0, _fleet_integration.isCspPackagePolicyInstalled)(packagePolicyService, soClient, this.logger);
            if (!isPackageExists) {
              await this.uninstallResources(plugins.taskManager, this.logger);
            }
          }
        }
      });
    }).catch(() => {}); // it shouldn't reject, but just in case

    return {};
  }
  stop() {}

  /**
   * Initialization is idempotent and required for (re)creating indices and transforms.
   */
  async initialize(core, taskManager) {
    this.logger.debug('initialize');
    const esClient = core.elasticsearch.client.asInternalUser;
    const soClient = core.savedObjects.createInternalRepository();
    await (0, _create_indices.initializeCspIndices)(esClient, this.config, this.logger);
    await (0, _create_transforms.initializeCspTransforms)(esClient, this.logger);
    await (0, _findings_stats_task.scheduleFindingsStatsTask)(taskManager, this.logger);
    // Delete old and legacy CDR data views for all spaces
    await (0, _data_views.deleteOldAndLegacyCdrDataViewsForAllSpaces)(soClient, this.logger);
    _classPrivateFieldSet(_isInitialized, this, true);
  }
  async uninstallResources(taskManager, logger) {
    await (0, _findings_stats_task.removeFindingsStatsTask)(taskManager, logger);
  }
  setupCspTasks(taskManager, coreStartServices, logger) {
    (0, _findings_stats_task.setupFindingsStatsTask)(taskManager, coreStartServices, logger);
  }
}
exports.CspPlugin = CspPlugin;
const isSingleEnabledInput = inputs => inputs.filter(i => i.enabled).length === 1;