"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputVarsFields = exports.getGcpCredentialsType = exports.gcpField = exports.GcpInputVarFields = exports.GcpCredentialsForm = exports.GCP_SETUP_ACCESS = exports.GCP_CREDENTIALS_TYPE = exports.GCPSetupInfoContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _csp_boxed_radio_group = require("../csp_boxed_radio_group");
var _utils = require("../utils");
var _constants2 = require("../../../common/constants");
var _constants3 = require("../../../common/navigation/constants");
var _aws_credentials_form = require("../aws_credentials_form/aws_credentials_form");
var _policy_template_form = require("../policy_template_form");
var _test_subjects = require("../../test_subjects");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GCP_SETUP_ACCESS = exports.GCP_SETUP_ACCESS = {
  CLOUD_SHELL: 'google_cloud_shell',
  MANUAL: 'manual'
};
const GCP_CREDENTIALS_TYPE = exports.GCP_CREDENTIALS_TYPE = {
  CREDENTIALS_FILE: 'credentials-file',
  CREDENTIALS_JSON: 'credentials-json',
  CREDENTIALS_NONE: 'credentials-none'
};
const GCPSetupInfoContent = ({
  isAgentless
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "xl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.gcpIntegration.setupInfoContentTitle",
  defaultMessage: "Setup Access"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, isAgentless ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.gcpIntegration.agentlessSetupInfoContent",
  defaultMessage: "The integration will need elevated access to run some CIS benchmark rules.You can follow these step-by-step instructions to generate the necessary credentials. Refer to our {gettingStartedLink} guide for details.",
  values: {
    gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _constants3.cspIntegrationDocsNavigation.cspm.gcpGetStartedPath,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.azureIntegration.gettingStarted.agentlessSetupInfoContentLink",
      defaultMessage: "Getting Started"
    }))
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.gcpIntegration.setupInfoContent",
  defaultMessage: "The integration will need elevated access to run some CIS benchmark rules. Select your preferred\nmethod of providing the GCP credentials this integration will use. You can follow these\nstep-by-step instructions to generate the necessary credentials. Refer to our {gettingStartedLink} guide for details.",
  values: {
    gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _constants3.cspIntegrationDocsNavigation.cspm.gcpGetStartedPath,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.azureIntegration.gettingStarted.setupInfoContentLink",
      defaultMessage: "Getting Started"
    }))
  }
})));
exports.GCPSetupInfoContent = GCPSetupInfoContent;
const GoogleCloudShellSetup = ({
  fields,
  onChange,
  input,
  disabled,
  hasInvalidRequiredVars
}) => {
  var _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$;
  const accountType = (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['gcp.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value;
  const getFieldById = id => {
    return fields.find(element => element.id === id);
  };
  const projectIdFields = getFieldById('gcp.project_id');
  const projectIdValueInvalid = (0, _utils.fieldIsInvalid)(projectIdFields === null || projectIdFields === void 0 ? void 0 : projectIdFields.value, hasInvalidRequiredVars);
  const projectIdError = `${projectIdFields === null || projectIdFields === void 0 ? void 0 : projectIdFields.label} is required`;
  const organizationIdFields = getFieldById('gcp.organization_id');
  const organizationIdValueInvalid = (0, _utils.fieldIsInvalid)(organizationIdFields === null || organizationIdFields === void 0 ? void 0 : organizationIdFields.value, hasInvalidRequiredVars);
  const organizationIdError = `${organizationIdFields === null || organizationIdFields === void 0 ? void 0 : organizationIdFields.label} is required`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.GOOGLE_CLOUD_SHELL_SETUP
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: (0, _react2.css)`
            list-style: auto;
          `
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.hostRequirement",
    defaultMessage: "Ensure \"New hosts\" is selected in the \"Where to add this integration?\" section below"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.login",
    defaultMessage: "Log into your Google Cloud Console"
  })), accountType === _policy_template_form.GCP_ORGANIZATION_ACCOUNT ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.organizationCloudShellSetupStep.save",
    defaultMessage: "Note down the GCP organization ID of the organization you wish to monitor and project ID where you want to provision resources for monitoring purposes and provide them in the input boxes below"
  })) : /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.save",
    defaultMessage: "Note down the GCP project ID of the project you wish to monitor"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.launch",
    defaultMessage: "Click \"Save and Continue\" at the bottom right of the page. Then, on the pop-up modal, click \"Launch Google Cloud Shell\""
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, organizationIdFields && accountType === _policy_template_form.GCP_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.organization_id'].label,
    isInvalid: organizationIdValueInvalid,
    error: organizationIdValueInvalid ? organizationIdError : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.ORGANIZATION_ID,
    id: organizationIdFields.id,
    fullWidth: true,
    value: organizationIdFields.value || '',
    onChange: event => onChange(organizationIdFields.id, event.target.value),
    isInvalid: organizationIdValueInvalid
  })), projectIdFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.project_id'].label,
    isInvalid: projectIdValueInvalid,
    error: projectIdValueInvalid ? projectIdError : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.PROJECT_ID,
    id: projectIdFields.id,
    fullWidth: true,
    value: projectIdFields.value || '',
    onChange: event => onChange(projectIdFields.id, event.target.value),
    isInvalid: projectIdValueInvalid
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const credentialOptionsList = [{
  text: _i18n.i18n.translate('xpack.csp.gcpIntegration.credentialsFileOption', {
    defaultMessage: 'Credentials File'
  }),
  value: GCP_CREDENTIALS_TYPE.CREDENTIALS_FILE,
  'data-test-subj': 'credentials_file_option_test_id'
}, {
  text: _i18n.i18n.translate('xpack.csp.gcpIntegration.credentialsJsonOption', {
    defaultMessage: 'Credentials JSON'
  }),
  value: GCP_CREDENTIALS_TYPE.CREDENTIALS_JSON,
  'data-test-subj': 'credentials_json_option_test_id'
}];
const gcpField = exports.gcpField = {
  fields: {
    'gcp.organization_id': {
      label: _i18n.i18n.translate('xpack.csp.gcpIntegration.organizationIdFieldLabel', {
        defaultMessage: 'Organization ID'
      }),
      type: 'text'
    },
    'gcp.project_id': {
      label: _i18n.i18n.translate('xpack.csp.gcpIntegration.projectidFieldLabel', {
        defaultMessage: 'Project ID'
      }),
      type: 'text'
    },
    'gcp.credentials.file': {
      label: _i18n.i18n.translate('xpack.csp.findings.gcpIntegration.gcpInputText.credentialFileText', {
        defaultMessage: 'Path to JSON file containing the credentials and key used to subscribe'
      }),
      type: 'text'
    },
    'gcp.credentials.json': {
      label: _i18n.i18n.translate('xpack.csp.findings.gcpIntegration.gcpInputText.credentialJSONText', {
        defaultMessage: 'JSON blob containing the credentials and key used to subscribe'
      }),
      type: 'password',
      isSecret: true
    },
    'gcp.credentials.type': {
      label: _i18n.i18n.translate('xpack.csp.findings.gcpIntegration.gcpInputText.credentialSelectBoxTitle', {
        defaultMessage: 'Credential'
      }),
      type: 'text'
    }
  }
};
const getSetupFormatOptions = () => [{
  id: GCP_SETUP_ACCESS.CLOUD_SHELL,
  label: _i18n.i18n.translate('xpack.csp.gcpIntegration.setupFormatOptions.googleCloudShell', {
    defaultMessage: 'Google Cloud Shell'
  }),
  disabled: false,
  testId: _test_subjects.GCP_CREDENTIALS_TYPE_OPTIONS_TEST_SUBJ.CLOUD_SHELL
}, {
  id: GCP_SETUP_ACCESS.MANUAL,
  label: _i18n.i18n.translate('xpack.csp.gcpIntegration.setupFormatOptions.manual', {
    defaultMessage: 'Manual'
  }),
  disabled: false,
  testId: _test_subjects.GCP_CREDENTIALS_TYPE_OPTIONS_TEST_SUBJ.MANUAL
}];
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    value: inputVar.value
  };
});
exports.getInputVarsFields = getInputVarsFields;
const getSetupFormatFromInput = input => {
  const credentialsType = getGcpCredentialsType(input);

  // Google Cloud shell is the default value
  if (!credentialsType) {
    return GCP_SETUP_ACCESS.CLOUD_SHELL;
  }
  if (credentialsType !== GCP_CREDENTIALS_TYPE.CREDENTIALS_NONE) {
    return GCP_SETUP_ACCESS.MANUAL;
  }
  return GCP_SETUP_ACCESS.CLOUD_SHELL;
};
const getGoogleCloudShellUrl = newPolicy => {
  var _newPolicy$inputs, _newPolicy$inputs$fin, _newPolicy$inputs$fin2, _newPolicy$inputs$fin3;
  const template = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$fin = _newPolicy$inputs.find(i => i.type === _constants.CLOUDBEAT_GCP)) === null || _newPolicy$inputs$fin === void 0 ? void 0 : (_newPolicy$inputs$fin2 = _newPolicy$inputs$fin.config) === null || _newPolicy$inputs$fin2 === void 0 ? void 0 : (_newPolicy$inputs$fin3 = _newPolicy$inputs$fin2.cloud_shell_url) === null || _newPolicy$inputs$fin3 === void 0 ? void 0 : _newPolicy$inputs$fin3.value;
  return template || undefined;
};
const updateCloudShellUrl = (newPolicy, updatePolicy, templateUrl) => {
  updatePolicy === null || updatePolicy === void 0 ? void 0 : updatePolicy({
    ...newPolicy,
    inputs: newPolicy.inputs.map(input => {
      if (input.type === _constants.CLOUDBEAT_GCP) {
        return {
          ...input,
          config: {
            cloud_shell_url: {
              value: templateUrl
            }
          }
        };
      }
      return input;
    })
  });
};
const useCloudShellUrl = ({
  packageInfo,
  newPolicy,
  updatePolicy,
  setupFormat
}) => {
  var _newPolicy$vars;
  (0, _react.useEffect)(() => {
    const policyInputCloudShellUrl = getGoogleCloudShellUrl(newPolicy);
    if (setupFormat === GCP_SETUP_ACCESS.MANUAL) {
      if (!!policyInputCloudShellUrl) {
        updateCloudShellUrl(newPolicy, updatePolicy, undefined);
      }
      return;
    }
    const templateUrl = (0, _utils.getCspmCloudShellDefaultValue)(packageInfo);

    // If the template is not available, do not update the policy
    if (templateUrl === '') return;

    // If the template is already set, do not update the policy
    if (policyInputCloudShellUrl === templateUrl) return;
    updateCloudShellUrl(newPolicy, updatePolicy, templateUrl);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$vars = newPolicy.vars) === null || _newPolicy$vars === void 0 ? void 0 : _newPolicy$vars.cloud_shell_url, newPolicy, packageInfo, setupFormat]);
};
const getGcpCredentialsType = input => {
  var _input$streams$0$vars;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : _input$streams$0$vars['gcp.credentials.type'].value;
};
exports.getGcpCredentialsType = getGcpCredentialsType;
const GcpCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  setIsValid,
  onChange,
  disabled,
  isEditPage,
  hasInvalidRequiredVars
}) => {
  var _input$streams2, _input$streams2$, _input$streams2$$vars, _input$streams2$$vars2;
  /* Create a subset of properties from GcpField to use for hiding value of credentials json and credentials file when user switch from Manual to Cloud Shell, we wanna keep Project and Organization ID */
  const subsetOfGcpField = (({
    ['gcp.credentials.file']: a,
    ['gcp.credentials.json']: b
  }) => ({
    'gcp.credentials.file': a,
    ['gcp.credentials.json']: b
  }))(gcpField.fields);
  const fieldsToHide = getInputVarsFields(input, subsetOfGcpField);
  const fields = getInputVarsFields(input, gcpField.fields);
  const validSemantic = (0, _valid.default)(packageInfo.version);
  const integrationVersionNumberOnly = (0, _coerce.default)(validSemantic) || '';
  const isInvalid = (0, _lt.default)(integrationVersionNumberOnly, _constants2.MIN_VERSION_GCP_CIS);
  const fieldsSnapshot = (0, _react.useRef)({});
  const lastCredentialsType = (0, _react.useRef)(undefined);
  const setupFormat = getSetupFormatFromInput(input);
  const accountType = (_input$streams2 = input.streams) === null || _input$streams2 === void 0 ? void 0 : (_input$streams2$ = _input$streams2[0]) === null || _input$streams2$ === void 0 ? void 0 : (_input$streams2$$vars = _input$streams2$.vars) === null || _input$streams2$$vars === void 0 ? void 0 : (_input$streams2$$vars2 = _input$streams2$$vars['gcp.account_type']) === null || _input$streams2$$vars2 === void 0 ? void 0 : _input$streams2$$vars2.value;
  const isOrganization = accountType === 'organization-account';
  // Integration is Invalid IF Version is not at least 1.5.0 OR Setup Access is manual but Project ID is empty
  (0, _react.useEffect)(() => {
    const isInvalidPolicy = isInvalid;
    setIsValid(!isInvalidPolicy);
    onChange({
      isValid: !isInvalidPolicy,
      updatedPolicy: newPolicy
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setupFormat, input.type]);
  useCloudShellUrl({
    packageInfo,
    newPolicy,
    updatePolicy,
    setupFormat
  });
  const onSetupFormatChange = newSetupFormat => {
    if (newSetupFormat === GCP_SETUP_ACCESS.CLOUD_SHELL) {
      // We need to store the current manual fields to restore them later
      fieldsSnapshot.current = Object.fromEntries(fieldsToHide.map(field => [field.id, {
        value: field.value
      }]));
      // We need to store the last manual credentials type to restore it later
      lastCredentialsType.current = getGcpCredentialsType(input);
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'gcp.credentials.type': {
          value: GCP_CREDENTIALS_TYPE.CREDENTIALS_NONE,
          type: 'text'
        },
        // Clearing fields from previous setup format to prevent exposing credentials
        // when switching from manual to cloud formation
        ...Object.fromEntries(fieldsToHide.map(field => [field.id, {
          value: undefined
        }]))
      }));
    } else {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'gcp.credentials.type': {
          // Restoring last manual credentials type
          value: lastCredentialsType.current || GCP_CREDENTIALS_TYPE.CREDENTIALS_FILE,
          type: 'text'
        },
        // Restoring fields from manual setup format if any
        ...fieldsSnapshot.current
      }));
    }
  };
  if (isInvalid) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.gcpIntegration.gcpNotSupportedMessage",
      defaultMessage: "CIS GCP is not supported on the current Integration version, please upgrade your integration to the latest version to use CIS GCP"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(GCPSetupInfoContent, {
    isAgentless: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    size: "m",
    options: getSetupFormatOptions(),
    idSelected: setupFormat,
    onChange: idSelected => idSelected !== setupFormat && onSetupFormatChange(idSelected)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setupFormat === GCP_SETUP_ACCESS.CLOUD_SHELL ? /*#__PURE__*/_react.default.createElement(GoogleCloudShellSetup, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    input: input,
    hasInvalidRequiredVars: hasInvalidRequiredVars
  }) : /*#__PURE__*/_react.default.createElement(GcpInputVarFields, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    isOrganization: isOrganization,
    packageInfo: packageInfo,
    isEditPage: isEditPage,
    hasInvalidRequiredVars: hasInvalidRequiredVars
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: _constants3.cspIntegrationDocsNavigation.cspm.gcpGetStartedPath
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.GcpCredentialsForm = GcpCredentialsForm;
const GcpInputVarFields = ({
  fields,
  onChange,
  isOrganization,
  disabled,
  packageInfo,
  isEditPage,
  hasInvalidRequiredVars
}) => {
  const getFieldById = id => {
    return fields.find(element => element.id === id);
  };
  const organizationIdFields = getFieldById('gcp.organization_id');
  const projectIdFields = getFieldById('gcp.project_id');
  const credentialsTypeFields = getFieldById('gcp.credentials.type');
  const credentialFilesFields = getFieldById('gcp.credentials.file');
  const credentialFilesFieldsInvalid = (0, _utils.fieldIsInvalid)(credentialFilesFields === null || credentialFilesFields === void 0 ? void 0 : credentialFilesFields.value, hasInvalidRequiredVars);
  const credentialFilesError = _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.fieldRequired', {
    defaultMessage: '{field} is required',
    values: {
      field: credentialFilesFields === null || credentialFilesFields === void 0 ? void 0 : credentialFilesFields.label
    }
  });
  const credentialJSONFields = getFieldById('gcp.credentials.json');
  const credentialJSONFieldsInvalid = (0, _utils.fieldIsInvalid)(credentialJSONFields === null || credentialJSONFields === void 0 ? void 0 : credentialJSONFields.value, hasInvalidRequiredVars);
  const credentialJSONError = _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.fieldRequired', {
    defaultMessage: '{field} is required',
    values: {
      field: credentialJSONFields === null || credentialJSONFields === void 0 ? void 0 : credentialJSONFields.label
    }
  });
  const credentialFieldValue = credentialOptionsList[0].value;
  const credentialJSONValue = credentialOptionsList[1].value;
  const credentialsTypeValue = (credentialsTypeFields === null || credentialsTypeFields === void 0 ? void 0 : credentialsTypeFields.value) || credentialFilesFields && credentialFieldValue || credentialJSONFields && credentialJSONValue;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, organizationIdFields && isOrganization && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.organization_id'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.ORGANIZATION_ID,
    id: organizationIdFields.id,
    fullWidth: true,
    value: organizationIdFields.value || '',
    onChange: event => onChange(organizationIdFields.id, event.target.value)
  })), projectIdFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.project_id'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.PROJECT_ID,
    id: projectIdFields.id,
    fullWidth: true,
    value: projectIdFields.value || '',
    onChange: event => onChange(projectIdFields.id, event.target.value)
  })), credentialsTypeFields && credentialFilesFields && credentialJSONFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.credentials.type'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.CREDENTIALS_TYPE,
    fullWidth: true,
    options: credentialOptionsList,
    value: (credentialsTypeFields === null || credentialsTypeFields === void 0 ? void 0 : credentialsTypeFields.value) || credentialOptionsList[0].value,
    onChange: optionElem => {
      onChange(credentialsTypeFields === null || credentialsTypeFields === void 0 ? void 0 : credentialsTypeFields.id, optionElem.target.value);
    }
  })), credentialsTypeValue === credentialFieldValue && credentialFilesFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.credentials.file'].label,
    isInvalid: credentialFilesFieldsInvalid,
    error: credentialFilesFieldsInvalid ? credentialFilesError : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.CREDENTIALS_FILE,
    id: credentialFilesFields.id,
    fullWidth: true,
    value: credentialFilesFields.value || '',
    onChange: event => onChange(credentialFilesFields.id, event.target.value),
    isInvalid: credentialFilesFieldsInvalid
  })), credentialsTypeValue === credentialJSONValue && credentialJSONFields && /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              width: 100%;
              .euiFormControlLayout,
              .euiFormControlLayout__childrenWrapper,
              .euiFormRow,
              input {
                max-width: 100%;
                width: 100%;
              }
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.credentials.json'].label,
    isInvalid: credentialJSONFieldsInvalid,
    error: credentialJSONFieldsInvalid ? credentialJSONError : undefined
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    })
  }, /*#__PURE__*/_react.default.createElement(_public.LazyPackagePolicyInputVarField, {
    "data-test-subj": _test_subjects.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.CREDENTIALS_JSON,
    varDef: {
      ...(0, _utils.findVariableDef)(packageInfo, credentialJSONFields.id),
      required: true,
      type: 'textarea',
      secret: true,
      full_width: true
    },
    value: credentialJSONFields.value || '',
    onChange: value => {
      onChange(credentialJSONFields.id, value);
    },
    isEditPage: isEditPage
  }))))));
};
exports.GcpInputVarFields = GcpInputVarFields;