"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGeneralViewSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _types = require("../../types");
var _utils = require("../../common/utils");
var i18n = _interopRequireWildcard(require("../control_general_view/translations"));
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BooleanCondition = ({
  label,
  prop,
  selector,
  onChangeBooleanCondition,
  onRemoveCondition
}) => {
  const value = selector[prop];
  const onChange = (0, _react.useCallback)(e => {
    onChangeBooleanCondition(prop, e.target.checked);
  }, [onChangeBooleanCondition, prop]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    key: prop
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: prop,
    label: label,
    checked: value,
    onChange: onChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: () => onRemoveCondition(prop),
    "aria-label": "Remove condition",
    "data-test-subj": 'cloud-defend-btnremovecondition-' + prop
  }))));
};
const FlagCondition = ({
  label,
  prop,
  onRemoveCondition
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    key: prop
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("small", null, i18n.getConditionHelpLabel(prop))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: () => onRemoveCondition(prop),
    "aria-label": "Remove condition",
    "data-test-subj": 'cloud-defend-btnremovecondition-' + prop
  }))));
};
const StringArrayCondition = ({
  label,
  prop,
  selector,
  errorMap,
  onRemoveCondition,
  onAddValueToCondition,
  onChangeStringArrayCondition
}) => {
  const values = selector[prop];
  const selectedOptions = (values === null || values === void 0 ? void 0 : values.map(option => {
    return {
      label: option,
      value: option
    };
  })) || [];
  const restrictedValues = (0, _utils.getRestrictedValuesForCondition)(selector.type, prop);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    key: prop,
    isInvalid: !!Object.hasOwn(errorMap, prop)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": label,
    fullWidth: true,
    onCreateOption: !restrictedValues ? searchValue => onAddValueToCondition(prop, searchValue) : undefined,
    selectedOptions: selectedOptions,
    options: restrictedValues ? restrictedValues.map(value => ({
      label: value,
      value
    })) : selectedOptions,
    onChange: options => onChangeStringArrayCondition(prop, options.map(option => option.value)),
    isClearable: true,
    "data-test-subj": 'cloud-defend-selectorcondition-' + prop
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: () => onRemoveCondition(prop),
    "aria-label": "Remove condition",
    "data-test-subj": 'cloud-defend-btnremovecondition-' + prop
  }))));
};

/** main component */
const ControlGeneralViewSelector = ({
  selector,
  selectors,
  usedByResponse,
  index,
  onRemove,
  onDuplicate,
  onChange
}) => {
  // ensure most recently added is open by default
  const [accordionState, setAccordionState] = (0, _react.useState)(selectors.length - 1 === index ? 'open' : 'closed');
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [isAddConditionOpen, setAddConditionOpen] = (0, _react.useState)(false);
  const [errorMap, setErrorMap] = (0, _react.useState)({});
  const styles = (0, _styles.useStyles)();
  const onTogglePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(false);
  }, []);
  const onToggleAddCondition = (0, _react.useCallback)(() => {
    setAddConditionOpen(!isAddConditionOpen);
  }, [isAddConditionOpen]);
  const closeAddCondition = (0, _react.useCallback)(() => {
    setAddConditionOpen(false);
  }, []);
  const availableConditions = (0, _react.useMemo)(() => (0, _utils.getSelectorConditions)(selector.type), [selector]);
  const remainingConditions = (0, _react.useMemo)(() => {
    return availableConditions.filter(condition => !Object.hasOwn(selector, condition));
  }, [availableConditions, selector]);
  const conditionsAdded = (0, _react.useMemo)(() => {
    return Object.keys(selector).filter(key => !['type', 'hasErrors', 'name'].includes(key));
  }, [selector]);
  const onRemoveClicked = (0, _react.useCallback)(() => {
    // we prevent the removal of the last selector to avoid an empty state
    if (selectors.length > 1) {
      onRemove(index);
    }
    closePopover();
  }, [closePopover, index, onRemove, selectors.length]);
  const onDuplicateClicked = (0, _react.useCallback)(() => {
    onDuplicate(selector);
    closePopover();
  }, [closePopover, onDuplicate, selector]);
  const onNameChange = (0, _react.useCallback)(event => {
    const errors = [];
    const value = event.currentTarget.value;

    // look for duplicate names (selector names should be unique)
    const found = selectors.find(sel => sel.name === value);
    if (found) {
      errors.push(i18n.errorDuplicateName);
    }

    // ensure name is valid
    if (!_constants.VALID_SELECTOR_NAME_REGEX.test(value)) {
      errors.push(i18n.errorInvalidName);
    }
    if (errors.length) {
      errorMap.name = errors;
    } else {
      delete errorMap.name;
    }
    setErrorMap({
      ...errorMap
    });
    const updatedSelector = {
      ...selector
    };
    updatedSelector.name = value;
    updatedSelector.hasErrors = Object.keys(errorMap).length > 0 || conditionsAdded.length === 0;
    onChange(updatedSelector, index);
  }, [errorMap, index, conditionsAdded, onChange, selector, selectors]);
  const onChangeStringArrayCondition = (0, _react.useCallback)((prop, values) => {
    const updatedSelector = {
      ...selector,
      [prop]: values
    };
    const errors = [];
    if (values.length === 0) {
      errors.push(i18n.errorValueRequired);
    }
    const stringValueErrors = (0, _utils.validateStringValuesForCondition)(prop, values);
    if (stringValueErrors.length > 0) {
      errors.push(...stringValueErrors);
    }
    if (errors.length) {
      errorMap[prop] = errors;
    } else {
      delete errorMap[prop];
    }
    updatedSelector.hasErrors = Object.keys(errorMap).length > 0 || conditionsAdded.length === 0;
    setErrorMap({
      ...errorMap
    });
    onChange(updatedSelector, index);
  }, [errorMap, index, conditionsAdded, onChange, selector]);
  const onChangeBooleanCondition = (0, _react.useCallback)((prop, value) => {
    const updatedSelector = {
      ...selector,
      [prop]: value
    };
    onChange(updatedSelector, index);
  }, [index, onChange, selector]);
  const onAddCondition = (0, _react.useCallback)(prop => {
    const valueType = _types.SelectorConditionsMap[prop].type;
    if (valueType === 'flag' || valueType === 'boolean') {
      onChangeBooleanCondition(prop, true);
    } else {
      onChangeStringArrayCondition(prop, []);
    }
    closeAddCondition();
  }, [closeAddCondition, onChangeBooleanCondition, onChangeStringArrayCondition]);
  const onRemoveCondition = (0, _react.useCallback)(prop => {
    const updatedSelector = {
      ...selector
    };
    delete updatedSelector[prop];
    delete errorMap[prop];
    setErrorMap({
      ...errorMap
    });
    updatedSelector.hasErrors = Object.keys(errorMap).length > 0 || conditionsAdded.length === 1;
    onChange(updatedSelector, index);
    closeAddCondition();
  }, [closeAddCondition, conditionsAdded, errorMap, index, onChange, selector]);
  const onAddValueToCondition = (0, _react.useCallback)((prop, searchValue) => {
    const value = searchValue.trim();
    const values = selector[prop];
    if (values && values.indexOf(value) === -1) {
      onChangeStringArrayCondition(prop, [...values, value]);
    }
  }, [onChangeStringArrayCondition, selector]);
  const errors = (0, _react.useMemo)(() => {
    const errs = Object.keys(errorMap).reduce((prev, current) => {
      return prev.concat(errorMap[current]);
    }, []);
    if (conditionsAdded.length === 0) {
      errs.push(i18n.errorConditionRequired);
    }
    return errs;
  }, [errorMap, conditionsAdded]);
  const onToggleAccordion = (0, _react.useCallback)(isOpen => {
    setAccordionState(isOpen ? 'open' : 'closed');
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: selector.name,
    forceState: accordionState,
    onToggle: onToggleAccordion,
    "data-test-subj": "cloud-defend-selector",
    paddingSize: "m",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.getSelectorIconTooltip(selector.type)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      type: (0, _utils.getSelectorTypeIcon)(selector.type)
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("b", null, selector.name)))),
    css: styles.accordion,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement("div", null, accordionState === 'closed' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.conditionsBadge,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("b", null, i18n.conditions)), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      title: conditionsAdded.join(','),
      color: "hollow",
      "data-test-subj": "cloud-defend-conditions-count"
    }, conditionsAdded.length)), !usedByResponse && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      title: i18n.unusedSelectorHelp,
      color: "warning"
    }, i18n.unusedSelector), /*#__PURE__*/_react.default.createElement("div", {
      css: styles.verticalDivider
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: selector.name,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "boxesHorizontal",
        onClick: onTogglePopover,
        "aria-label": "Selector options",
        "data-test-subj": "cloud-defend-btnselectorpopover"
      }),
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "duplicate",
        icon: "copy",
        onClick: onDuplicateClicked,
        "data-test-subj": "cloud-defend-btnduplicateselector"
      }, i18n.duplicate), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "remove",
        icon: "trash",
        disabled: selectors.length < 2,
        onClick: onRemoveClicked,
        "data-test-subj": "cloud-defend-btndeleteselector"
      }, i18n.remove)]
    }))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    error: errors,
    isInvalid: errors.length > 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.name,
    fullWidth: true,
    isInvalid: !!Object.hasOwn(errorMap, 'name')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "name",
    value: selector.name,
    onChange: onNameChange,
    isInvalid: Object.hasOwn(errorMap, 'name'),
    "data-test-subj": "cloud-defend-selectorcondition-name",
    maxLength: _constants.MAX_SELECTOR_NAME_LENGTH
  })), conditionsAdded.map(prop => {
    const label = (0, _utils.camelToSentenceCase)(prop);
    const valueType = _types.SelectorConditionsMap[prop].type;
    if (valueType === 'flag') {
      return /*#__PURE__*/_react.default.createElement(FlagCondition, {
        key: prop,
        label: label,
        prop: prop,
        onRemoveCondition: onRemoveCondition
      });
    } else if (valueType === 'boolean') {
      return /*#__PURE__*/_react.default.createElement(BooleanCondition, {
        key: prop,
        label: label,
        selector: selector,
        prop: prop,
        onChangeBooleanCondition: onChangeBooleanCondition,
        onRemoveCondition: onRemoveCondition
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(StringArrayCondition, {
        key: prop,
        label: label,
        prop: prop,
        selector: selector,
        errorMap: errorMap,
        onAddValueToCondition: onAddValueToCondition,
        onChangeStringArrayCondition: onChangeStringArrayCondition,
        onRemoveCondition: onRemoveCondition
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "cloudDefendControlAddCondition",
    "data-test-subj": "cloud-defend-addconditionpopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onToggleAddCondition,
      iconType: "plusInCircle",
      "data-test-subj": "cloud-defend-btnaddselectorcondition"
    }, i18n.addSelectorCondition),
    isOpen: isAddConditionOpen,
    closePopover: closeAddCondition,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: remainingConditions.map(prop => {
      const label = (0, _utils.camelToSentenceCase)(prop);
      const disabled = (0, _utils.conditionCombinationInvalid)(conditionsAdded, prop);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": `cloud-defend-addmenu-${prop}`,
        key: prop,
        onClick: () => onAddCondition(prop),
        disabled: disabled
      }, label);
    })
  })));
};
exports.ControlGeneralViewSelector = ControlGeneralViewSelector;