"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicesStates = getIndicesStates;
exports.validateIngestPipelineName = validateIngestPipelineName;
var _apm = require("../../../../common/es_fields/apm");
var _get_apm_index_template_names = require("../helpers/get_apm_index_template_names");
var _get_field_caps = require("./get_field_caps");
var _get_indices = require("./get_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIndicesStates({
  esClient,
  apmIndices
}) {
  var _fieldCaps$fields$SER;
  const {
    indices,
    ingestPipelines
  } = await (0, _get_indices.getIndicesAndIngestPipelines)({
    esClient,
    apmIndices
  });
  const indicesWithPipelineId = Object.entries(indices).map(([key, value]) => {
    var _value$settings, _value$settings$index;
    return {
      index: key,
      dataStream: value.data_stream,
      pipelineId: (_value$settings = value.settings) === null || _value$settings === void 0 ? void 0 : (_value$settings$index = _value$settings.index) === null || _value$settings$index === void 0 ? void 0 : _value$settings$index.default_pipeline
    };
  });
  const fieldCaps = await (0, _get_field_caps.getFieldCaps)({
    esClient,
    apmIndices
  });
  const invalidFieldMappings = Object.values((_fieldCaps$fields$SER = fieldCaps.fields[_apm.SERVICE_NAME]) !== null && _fieldCaps$fields$SER !== void 0 ? _fieldCaps$fields$SER : {}).filter(({
    type
  }) => type !== 'keyword');
  const items = indicesWithPipelineId.map(({
    index,
    dataStream,
    pipelineId
  }) => {
    var _ingestPipelines$pipe, _ingestPipelines$pipe2;
    const hasObserverVersionProcessor = pipelineId ? (_ingestPipelines$pipe = ingestPipelines[pipelineId]) === null || _ingestPipelines$pipe === void 0 ? void 0 : (_ingestPipelines$pipe2 = _ingestPipelines$pipe.processors) === null || _ingestPipelines$pipe2 === void 0 ? void 0 : _ingestPipelines$pipe2.some(processor => {
      var _processor$grok, _processor$grok2;
      return (processor === null || processor === void 0 ? void 0 : (_processor$grok = processor.grok) === null || _processor$grok === void 0 ? void 0 : _processor$grok.field) === 'observer.version' && (processor === null || processor === void 0 ? void 0 : (_processor$grok2 = processor.grok) === null || _processor$grok2 === void 0 ? void 0 : _processor$grok2.patterns[0]) === '%{DIGITS:observer.version_major:int}.%{DIGITS:observer.version_minor:int}.%{DIGITS:observer.version_patch:int}(?:[-+].*)?';
    }) : false;
    const invalidFieldMapping = invalidFieldMappings.find(fieldMappings => {
      var _fieldMappings$indice;
      return (_fieldMappings$indice = fieldMappings.indices) === null || _fieldMappings$indice === void 0 ? void 0 : _fieldMappings$indice.includes(index);
    });
    const isValidFieldMappings = invalidFieldMapping === undefined;
    const isValidIngestPipeline = hasObserverVersionProcessor === true && validateIngestPipelineName(dataStream, pipelineId);
    return {
      isValid: isValidFieldMappings && isValidIngestPipeline,
      fieldMappings: {
        isValid: isValidFieldMappings,
        invalidType: invalidFieldMapping === null || invalidFieldMapping === void 0 ? void 0 : invalidFieldMapping.type
      },
      ingestPipeline: {
        isValid: isValidIngestPipeline,
        id: pipelineId
      },
      index,
      dataStream
    };
  });
  const invalidIndices = items.filter(item => !item.isValid);
  const validIndices = items.filter(item => item.isValid);
  return {
    invalidIndices,
    validIndices,
    indices,
    ingestPipelines,
    fieldCaps
  };
}
function validateIngestPipelineName(dataStream, ingestPipelineId) {
  if (!dataStream || !ingestPipelineId) {
    return false;
  }
  const indexTemplateNames = (0, _get_apm_index_template_names.getApmIndexTemplateNames)();
  return Object.values(indexTemplateNames).flat().some(indexTemplateName => dataStream.startsWith(indexTemplateName) && ingestPipelineId.startsWith(indexTemplateName));
}