"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDependencyDetailOperationsBreadcrumb = useDependencyDetailOperationsBreadcrumb;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_breadcrumb = require("../context/breadcrumbs/use_breadcrumb");
var _use_apm_params = require("./use_apm_params");
var _use_apm_router = require("./use_apm_router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDependencyDetailOperationsBreadcrumb(extraBreadCrumbs = []) {
  const {
    query: {
      dependencyName,
      rangeFrom,
      rangeTo,
      refreshInterval,
      refreshPaused,
      environment,
      kuery,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/dependencies/operations', '/dependencies/operation');
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _i18n.i18n.translate('xpack.apm.dependencyDetailOperations.breadcrumbTitle', {
      defaultMessage: 'Operations'
    }),
    href: apmRouter.link('/dependencies/operations', {
      query: {
        dependencyName,
        rangeFrom,
        rangeTo,
        refreshInterval,
        refreshPaused,
        environment,
        kuery,
        comparisonEnabled
      }
    })
  }, ...(0, _lodash.castArray)(extraBreadCrumbs)], [apmRouter, comparisonEnabled, dependencyName, environment, extraBreadCrumbs, kuery, rangeFrom, rangeTo, refreshInterval, refreshPaused]);
}