"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfallContext = void 0;
exports.TraceWaterfallContextProvider = TraceWaterfallContextProvider;
exports.groupByParent = groupByParent;
exports.useTraceWaterfallContext = useTraceWaterfallContext;
var _react = _interopRequireWildcard(require("react"));
var _toggle_accordion_button = require("./toggle_accordion_button");
var _trace_item_row = require("./trace_item_row");
var _use_trace_waterfall = require("./use_trace_waterfall");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TraceWaterfallContext = exports.TraceWaterfallContext = /*#__PURE__*/(0, _react.createContext)({
  duration: 0,
  traceState: _use_trace_waterfall.TraceDataState.Empty,
  traceWaterfall: [],
  rootItem: undefined,
  margin: {
    left: 0,
    right: 0
  },
  traceWaterfallMap: {},
  showAccordion: true,
  isEmbeddable: false
});
function TraceWaterfallContextProvider({
  children,
  traceItems,
  showAccordion,
  highlightedTraceId,
  onClick,
  onErrorClick,
  scrollElement,
  getRelatedErrorsHref,
  isEmbeddable
}) {
  const {
    duration,
    traceWaterfall,
    maxDepth,
    rootItem,
    traceState
  } = (0, _use_trace_waterfall.useTraceWaterfall)({
    traceItems
  });
  const left = _toggle_accordion_button.TOGGLE_BUTTON_WIDTH + _trace_item_row.ACCORDION_PADDING_LEFT * maxDepth;
  const right = 40;
  const traceWaterfallMap = (0, _react.useMemo)(() => groupByParent(traceWaterfall), [traceWaterfall]);
  return /*#__PURE__*/_react.default.createElement(TraceWaterfallContext.Provider, {
    value: {
      traceState,
      duration,
      rootItem,
      traceWaterfall,
      margin: {
        left: showAccordion ? Math.max(100, left) : left,
        right
      },
      traceWaterfallMap,
      showAccordion,
      onClick,
      onErrorClick,
      highlightedTraceId,
      scrollElement,
      getRelatedErrorsHref,
      isEmbeddable
    }
  }, children);
}
function useTraceWaterfallContext() {
  const context = (0, _react.useContext)(TraceWaterfallContext);
  if (!context) {
    throw new Error('useTraceWaterfallContext must be used within a TraceWaterfallContextProvider');
  }
  return context;
}
function groupByParent(items) {
  return items.reduce((acc, item) => {
    if (item.parentId) {
      if (!acc[item.parentId]) acc[item.parentId] = [];
      acc[item.parentId].push(item);
    }
    return acc;
  }, {});
}