"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatActionToEnqueue = void 0;
var _server = require("@kbn/actions-plugin/server");
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatActionToEnqueue = opts => {
  const {
    action,
    apiKey,
    apiKeyId,
    executionId,
    priority,
    ruleConsumer,
    ruleId,
    ruleTypeId,
    spaceId
  } = opts;
  const namespace = spaceId === 'default' ? {} : {
    namespace: spaceId
  };
  return {
    id: action.id,
    uuid: action.uuid,
    params: action.params,
    spaceId,
    apiKey: apiKey !== null && apiKey !== void 0 ? apiKey : null,
    apiKeyId,
    consumer: ruleConsumer,
    source: (0, _server.asSavedObjectExecutionSource)({
      id: ruleId,
      type: _.RULE_SAVED_OBJECT_TYPE
    }),
    executionId,
    relatedSavedObjects: [{
      id: ruleId,
      type: _.RULE_SAVED_OBJECT_TYPE,
      namespace: namespace.namespace,
      typeId: ruleTypeId
    }],
    actionTypeId: action.actionTypeId,
    priority
  };
};
exports.formatActionToEnqueue = formatActionToEnqueue;