"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizableContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _resize_observer = require("../observer/resize_observer");
var _context = require("./context");
var _resizable_button = require("./resizable_button");
var _resizable_panel = require("./resizable_panel");
var _helpers = require("./helpers");
var _resizable_container = require("./resizable_container.styles");
var _react2 = require("@emotion/react");
var _excluded = ["direction", "children", "className", "onPanelWidthChange", "onToggleCollapsed", "onResizeStart", "onResizeEnd"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var initialState = {
  isDragging: false,
  currentResizerPos: -1,
  prevPanelId: null,
  nextPanelId: null,
  containerSize: 1,
  panels: {},
  resizers: {}
};
var EuiResizableContainer = exports.EuiResizableContainer = function EuiResizableContainer(_ref) {
  var _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    children = _ref.children,
    className = _ref.className,
    onPanelWidthChange = _ref.onPanelWidthChange,
    onToggleCollapsed = _ref.onToggleCollapsed,
    onResizeStart = _ref.onResizeStart,
    onResizeEnd = _ref.onResizeEnd,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Note: It's important to memoize consumer callbacks to prevent our own functions
  // from reinstantiating unnecessarily & causing window event listeners to call stale closures
  var onResizeEndRef = (0, _services.useLatest)(onResizeEnd);
  var onResizeStartRef = (0, _services.useLatest)(onResizeStart);
  var containerRef = (0, _react.useRef)(null);
  var isHorizontal = direction === 'horizontal';
  var classes = (0, _classnames.default)('euiResizableContainer', className);
  var cssStyles = [_resizable_container.euiResizableContainerStyles.euiResizableContainer, _resizable_container.euiResizableContainerStyles[direction]];
  var _useContainerCallback = (0, _helpers.useContainerCallbacks)({
      initialState: _objectSpread(_objectSpread({}, initialState), {}, {
        isHorizontal: isHorizontal
      }),
      containerRef: containerRef,
      onPanelWidthChange: onPanelWidthChange
    }),
    _useContainerCallback2 = _slicedToArray(_useContainerCallback, 2),
    actions = _useContainerCallback2[0],
    reducerState = _useContainerCallback2[1];
  var containerSize = (0, _resize_observer.useResizeObserver)(containerRef.current, isHorizontal ? 'width' : 'height');
  var initialize = (0, _react.useCallback)(function () {
    actions.initContainer(isHorizontal);
  }, [actions, isHorizontal]);
  (0, _react.useEffect)(function () {
    if (containerSize.width > 0 && containerSize.height > 0) {
      initialize();
    }
  }, [initialize, containerSize]);
  var resizeContext = (0, _react.useRef)({});
  var resizeEnd = (0, _react.useCallback)(function () {
    var _onResizeEndRef$curre;
    (_onResizeEndRef$curre = onResizeEndRef.current) === null || _onResizeEndRef$curre === void 0 || _onResizeEndRef$curre.call(onResizeEndRef);
    resizeContext.current = {};
  }, [onResizeEndRef]);
  var resizeStart = (0, _react.useCallback)(function (trigger, keyMoveDirection) {
    var _onResizeStartRef$cur;
    // If another resize starts while the previous one is still in progress
    // (e.g. user presses opposite arrow to change direction while the first
    // is still held down, or user presses an arrow while dragging with the
    // mouse), we want to signal the end of the previous resize first.
    if (resizeContext.current.trigger) {
      resizeEnd();
    }
    (_onResizeStartRef$cur = onResizeStartRef.current) === null || _onResizeStartRef$cur === void 0 || _onResizeStartRef$cur.call(onResizeStartRef, trigger);
    resizeContext.current = {
      trigger: trigger,
      keyMoveDirection: keyMoveDirection
    };
  }, [onResizeStartRef, resizeEnd]);
  var onMouseDown = (0, _react.useCallback)(function (event) {
    var currentTarget = event.currentTarget;
    var prevPanel = currentTarget.previousElementSibling;
    var nextPanel = currentTarget.nextElementSibling;
    if (!prevPanel || !nextPanel) return;
    var prevPanelId = prevPanel.id;
    var nextPanelId = nextPanel.id;
    var position = (0, _helpers.getPosition)(event, isHorizontal);
    resizeStart('pointer');
    actions.dragStart({
      position: position,
      prevPanelId: prevPanelId,
      nextPanelId: nextPanelId
    });

    // Window event listeners instead of React events are used to continue
    // detecting movement even if the user's mouse leaves the container

    var onMouseMove = function onMouseMove(event) {
      var position = (0, _helpers.getPosition)(event, isHorizontal);
      actions.dragMove({
        position: position,
        prevPanelId: prevPanelId,
        nextPanelId: nextPanelId
      });
    };
    var onMouseUp = function onMouseUp() {
      if (resizeContext.current.trigger === 'pointer') {
        resizeEnd();
      }
      actions.reset();
      window.removeEventListener('mousemove', onMouseMove);
      window.removeEventListener('mouseup', onMouseUp);
      window.removeEventListener('touchmove', onMouseMove);
      window.removeEventListener('touchend', onMouseUp);
    };
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [actions, isHorizontal, resizeStart, resizeEnd]);
  var getKeyMoveDirection = (0, _react.useCallback)(function (key) {
    var direction = null;
    if (isHorizontal && key === _services.keys.ARROW_LEFT || !isHorizontal && key === _services.keys.ARROW_UP) {
      direction = 'backward';
    } else if (isHorizontal && key === _services.keys.ARROW_RIGHT || !isHorizontal && key === _services.keys.ARROW_DOWN) {
      direction = 'forward';
    }
    return direction;
  }, [isHorizontal]);
  var onKeyDown = (0, _react.useCallback)(function (event) {
    var key = event.key,
      currentTarget = event.currentTarget;
    var direction = getKeyMoveDirection(key);
    var prevPanelId = currentTarget.previousElementSibling.id;
    var nextPanelId = currentTarget.nextElementSibling.id;
    if (direction && prevPanelId && nextPanelId) {
      if (!event.repeat) {
        resizeStart('key', direction);
      }
      event.preventDefault();
      actions.keyMove({
        direction: direction,
        prevPanelId: prevPanelId,
        nextPanelId: nextPanelId
      });
    }
  }, [actions, getKeyMoveDirection, resizeStart]);
  var onKeyUp = (0, _react.useCallback)(function (_ref2) {
    var key = _ref2.key;
    // We only want to signal the end of a resize if the key that was released
    // is the same as the one that started the resize. This prevents the end
    // of a resize if the user presses one arrow key, then presses the opposite
    // arrow key to change direction, then releases the first arrow key.
    if (resizeContext.current.trigger === 'key' && resizeContext.current.keyMoveDirection === getKeyMoveDirection(key)) {
      resizeEnd();
    }
  }, [getKeyMoveDirection, resizeEnd]);
  var onBlur = (0, _react.useCallback)(function () {
    if (resizeContext.current.trigger === 'key') {
      resizeEnd();
    }
    actions.resizerBlur();
  }, [actions, resizeEnd]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  var EuiResizableButton = (0, _react.useCallback)((0, _resizable_button.euiResizableButtonWithControls)({
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onFocus: actions.resizerFocus,
    onBlur: onBlur,
    isHorizontal: isHorizontal,
    registration: {
      register: actions.registerResizer,
      deregister: actions.deregisterResizer
    }
  }), [actions, isHorizontal]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  var EuiResizablePanel = (0, _react.useCallback)((0, _resizable_panel.euiResizablePanelWithControls)({
    isHorizontal: isHorizontal,
    registration: {
      register: actions.registerPanel,
      deregister: actions.deregisterPanel
    },
    onToggleCollapsed: onToggleCollapsed,
    onToggleCollapsedInternal: actions.togglePanel
  }), [actions, isHorizontal]);
  var render = function render() {
    var DEFAULT = 'custom';
    var content = children(EuiResizablePanel, EuiResizableButton, {
      togglePanel: actions.togglePanel
    });
    var modes = /*#__PURE__*/_react.default.isValidElement(content) ? content.props.children.map(function (el) {
      return (0, _resizable_panel.getModeType)(el.props.mode) || DEFAULT;
    }) : null;
    if (modes && (['collapsible', 'main'].every(function (i) {
      return modes.includes(i);
    }) || modes.every(function (i) {
      return i === DEFAULT;
    }))) {
      return content;
    } else {
      throw new Error('Both `collapsible` and `main` mode panels are required.');
    }
  };
  return (0, _react2.jsx)(_context.EuiResizableContainerContextProvider, {
    registry: {
      panels: reducerState.panels,
      resizers: reducerState.resizers
    }
  }, (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes,
    ref: containerRef
  }, rest), render()));
};
EuiResizableContainer.propTypes = {
  /**
     * Specify the container direction
     */
  direction: _propTypes.default.oneOf(["vertical", "horizontal"]),
  /**
     * Pure function which accepts Panel and Resizer components in arguments
     * and returns a component tree
     */
  children: _propTypes.default.func.isRequired,
  /**
     * Pure function which accepts an object where keys are IDs of panels, which sizes were changed,
     * and values are actual sizes in percents
     */
  onPanelWidthChange: _propTypes.default.func,
  onToggleCollapsed: _propTypes.default.func,
  /**
     * Called when resizing starts
     */
  onResizeStart: _propTypes.default.func,
  /**
     * Called when resizing ends
     */
  onResizeEnd: _propTypes.default.func,
  style: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};