"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiExpressionValueStyles = exports.euiExpressionStyles = exports.euiExpressionIconStyles = exports.euiExpressionDescriptionStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _color = require("../../services/color");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _colorCSS = function _colorCSS(color) {
  return "\n    &:focus {\n      background-color: ".concat((0, _color.transparentize)(color, 0.1), ";\n    }\n  ");
};
var euiExpressionStyles = exports.euiExpressionStyles = function euiExpressionStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiExpression: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextBreakWord)(), " display:inline-block;font-family:", euiTheme.font.familyCode, ";", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), " ", (0, _global_styling.logicalTextAlignCSS)('left'), " ", (0, _global_styling.logicalShorthandCSS)('padding', "".concat((0, _global_styling.mathWithUnits)(euiTheme.size.s, function (x) {
      return x / 2;
    }), " 0")), " color:", euiTheme.colors.textParagraph, ";&:focus{", (0, _global_styling.logicalCSS)('border-bottom-style', 'solid'), ";}&+.euiExpression{", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";};label:euiExpression;"),
    // Variants
    columns: /*#__PURE__*/(0, _react.css)("display:flex;", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.xs), " padding:", euiTheme.size.xs, ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // Render the bottom border in high contrast mode for extra visibility
      none: "\n          border-radius: ".concat(euiTheme.size.xs, ";\n          border-color: transparent;\n        ")
    }), ";;label:columns;"),
    truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '100%'), ";;label:truncate;"),
    // States
    isClickable: /*#__PURE__*/(0, _react.css)("cursor:pointer;", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.editable), " &[class*='-columns']{background-color:", euiTheme.colors.lightestShade, ";&:focus,&:hover:not(:disabled){[class*='euiExpression__description'],[class*='euiExpression__value']{text-decoration:underline;}}};label:isClickable;"),
    isActive: {
      base: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-bottom-style', 'solid'), ";;label:base;"),
      subdued: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.textSubdued, ";;label:subdued;"),
      primary: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.primary, ";;label:primary;"),
      success: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.success, ";;label:success;"),
      warning: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.warning, ";;label:warning;"),
      danger: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.danger, ";;label:danger;"),
      accent: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.accent, ";;label:accent;")
    },
    subdued: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textSubdued), ";label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textPrimary), ";label:primary;"),
    success: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textSuccess), ";label:success;"),
    warning: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textWarning), ";label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textDanger), ";label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textAccent), ";label:accent;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "shrg0y-isUppercase",
  styles: "text-transform:uppercase;label:isUppercase;"
} : {
  name: "shrg0y-isUppercase",
  styles: "text-transform:uppercase;label:isUppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiExpressionDescriptionStyles = exports.euiExpressionDescriptionStyles = function euiExpressionDescriptionStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiExpression__description: /*#__PURE__*/(0, _react.css)(";label:euiExpression__description;"),
    truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " display:inline-block;vertical-align:bottom;;label:truncate;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSubdued, ";;label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textPrimary, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSuccess, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textWarning, ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textDanger, ";;label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccent, ";;label:accent;"),
    isUppercase: _ref,
    columns: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), " ", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.s), " flex-shrink:0;;label:columns;")
  };
};
var euiExpressionValueStyles = exports.euiExpressionValueStyles = {
  euiExpression__value: /*#__PURE__*/(0, _react.css)(";label:euiExpression__value;"),
  truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " display:inline-block;vertical-align:bottom;;label:truncate;"),
  columns: process.env.NODE_ENV === "production" ? {
    name: "29cdh2-columns",
    styles: "flex-grow:1;label:columns;"
  } : {
    name: "29cdh2-columns",
    styles: "flex-grow:1;label:columns;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};
var euiExpressionIconStyles = exports.euiExpressionIconStyles = function euiExpressionIconStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiExpression__icon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";;label:euiExpression__icon;"),
    columns: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', euiTheme.size.xs), ";;label:columns;")
  };
};