"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForRegistryNamingCollision = exports.checkForNamingCollision = exports.checkForInstallationNamingCollision = exports.NamingCollisionError = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _audit_logging = require("../../../../audit_logging");
var _common = require("../../../../../../common");
var Registry = _interopRequireWildcard(require("../../../registry"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkForNamingCollision = async (savedObjectsClient, integrationName) => {
  await checkForRegistryNamingCollision(savedObjectsClient, integrationName);
  await checkForInstallationNamingCollision(savedObjectsClient, integrationName);
};
exports.checkForNamingCollision = checkForNamingCollision;
const checkForRegistryNamingCollision = async (savedObjectsClient, integrationName) => {
  const registryOrBundledPackage = await Registry.fetchFindLatestPackageOrUndefined(integrationName);
  if (registryOrBundledPackage) {
    const registryConflictMessage = _i18n.i18n.translate('xpack.fleet.customIntegrations.namingCollisionError.registryOrBundle', {
      defaultMessage: 'Failed to create the integration as an integration with the name {integrationName} already exists in the package registry or as a bundled package.',
      values: {
        integrationName
      }
    });
    throw new NamingCollisionError(registryConflictMessage);
  }
};
exports.checkForRegistryNamingCollision = checkForRegistryNamingCollision;
const checkForInstallationNamingCollision = async (savedObjectsClient, integrationName) => {
  const result = await savedObjectsClient.find({
    type: _common.PACKAGES_SAVED_OBJECT_TYPE,
    perPage: 1,
    filter: _esQuery.nodeBuilder.and([_esQuery.nodeBuilder.is(`${_common.PACKAGES_SAVED_OBJECT_TYPE}.attributes.name`, integrationName)])
  });
  if (result.saved_objects.length > 0) {
    const installationConflictMessage = _i18n.i18n.translate('xpack.fleet.customIntegrations.namingCollisionError.installationConflictMessage', {
      defaultMessage: 'Failed to create the integration as an installation with the name {integrationName} already exists.',
      values: {
        integrationName
      }
    });
    throw new NamingCollisionError(installationConflictMessage);
  }
  for (const savedObject of result.saved_objects) {
    _audit_logging.auditLoggingService.writeCustomSoAuditLog({
      action: 'find',
      id: savedObject.id,
      savedObjectType: _common.PACKAGES_SAVED_OBJECT_TYPE
    });
  }
};
exports.checkForInstallationNamingCollision = checkForInstallationNamingCollision;
class NamingCollisionError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'NamingCollisionError';
  }
}
exports.NamingCollisionError = NamingCollisionError;