"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDownloadSourceProxyArgs = exports.getDownloadBaseUrl = exports.ManualInstructions = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getfleetServerHostsEnrollArgs(apiKey, fleetServerHost, fleetProxy) {
  const proxyHeadersArgs = fleetProxy !== null && fleetProxy !== void 0 && fleetProxy.proxy_headers ? Object.entries(fleetProxy.proxy_headers).reduce((acc, [proxyKey, proyVal]) => {
    acc += ` --proxy-header "${proxyKey}=${proyVal}"`;
    return acc;
  }, '') : '';
  const proxyArgs = fleetProxy ? ` --proxy-url=${fleetProxy.url}${proxyHeadersArgs}` : '';
  return `--url=${fleetServerHost || `FLEET_SERVER_HOST`} --enrollment-token=${apiKey}${proxyArgs}`;
}
const getDownloadBaseUrl = downloadSource => {
  const source = (downloadSource === null || downloadSource === void 0 ? void 0 : downloadSource.host) || _constants.DEFAULT_DOWNLOAD_SOURCE_URI;
  return source.endsWith('/') ? source.substring(0, source.length - 1) : source;
};
exports.getDownloadBaseUrl = getDownloadBaseUrl;
const getDownloadSourceProxyArgs = downloadSourceProxy => {
  const windows = `${downloadSourceProxy !== null && downloadSourceProxy !== void 0 && downloadSourceProxy.url ? `-Proxy "${downloadSourceProxy.url}"` : ''} ${downloadSourceProxy !== null && downloadSourceProxy !== void 0 && downloadSourceProxy.proxy_headers ? `-Headers @{${Object.entries(downloadSourceProxy.proxy_headers).reduce((acc, [proxyKey, proyVal]) => {
    acc.push(`"${proxyKey}"="${proyVal}"`);
    return acc;
  }, []).join('; ')}}` : ''}`.trim();
  const curl = `${downloadSourceProxy !== null && downloadSourceProxy !== void 0 && downloadSourceProxy.url ? `--proxy ${downloadSourceProxy.url}` : ''} ${downloadSourceProxy !== null && downloadSourceProxy !== void 0 && downloadSourceProxy.proxy_headers ? Object.entries(downloadSourceProxy.proxy_headers).reduce((acc, [proxyKey, proyVal]) => {
    acc.push(`--proxy-header "${proxyKey}=${proyVal}"`);
    return acc;
  }, []).join(' ') : ''}`.trim();
  return {
    windows,
    curl
  };
};
exports.getDownloadSourceProxyArgs = getDownloadSourceProxyArgs;
const ManualInstructions = ({
  apiKey,
  fleetServerHost,
  fleetProxy,
  downloadSource,
  downloadSourceProxy,
  agentVersion: agentVersion,
  gcpProjectId = '<PROJECT_ID>',
  gcpOrganizationId = '<ORGANIZATION_ID>',
  gcpAccountType
}) => {
  var _enrollArgs$split, _enrollArgs$split$pop;
  const enrollArgs = getfleetServerHostsEnrollArgs(apiKey, fleetServerHost, fleetProxy);
  const downloadBaseUrl = getDownloadBaseUrl(downloadSource);
  const fleetServerUrl = enrollArgs === null || enrollArgs === void 0 ? void 0 : (_enrollArgs$split = enrollArgs.split('--url=')) === null || _enrollArgs$split === void 0 ? void 0 : (_enrollArgs$split$pop = _enrollArgs$split.pop()) === null || _enrollArgs$split$pop === void 0 ? void 0 : _enrollArgs$split$pop.split('--enrollment')[0];
  const enrollmentToken = enrollArgs === null || enrollArgs === void 0 ? void 0 : enrollArgs.split('--enrollment-token=')[1];
  const k8sCommand = `kubectl apply -f elastic-agent-managed-kubernetes.yml`;
  const {
    windows: windowsDownloadSourceProxyArgs,
    curl: curlDownloadSourceProxyArgs
  } = getDownloadSourceProxyArgs(downloadSourceProxy);
  const linuxCommand = `curl -L -O ${downloadBaseUrl}/beats/elastic-agent/elastic-agent-${agentVersion}-linux-x86_64.tar.gz ${curlDownloadSourceProxyArgs}
tar xzvf elastic-agent-${agentVersion}-linux-x86_64.tar.gz
cd elastic-agent-${agentVersion}-linux-x86_64
sudo ./elastic-agent install ${enrollArgs}`;
  const macCommand = `curl -L -O ${downloadBaseUrl}/beats/elastic-agent/elastic-agent-${agentVersion}-darwin-aarch64.tar.gz ${curlDownloadSourceProxyArgs}
tar xzvf elastic-agent-${agentVersion}-darwin-aarch64.tar.gz
cd elastic-agent-${agentVersion}-darwin-aarch64
sudo ./elastic-agent install ${enrollArgs}`;
  const windowsCommand = `$ProgressPreference = 'SilentlyContinue'
Invoke-WebRequest -Uri ${downloadBaseUrl}/beats/elastic-agent/elastic-agent-${agentVersion}-windows-x86_64.zip -OutFile elastic-agent-${agentVersion}-windows-x86_64.zip ${windowsDownloadSourceProxyArgs}
Expand-Archive .\\elastic-agent-${agentVersion}-windows-x86_64.zip -DestinationPath .
cd elastic-agent-${agentVersion}-windows-x86_64
.\\elastic-agent.exe install ${enrollArgs}`;
  const linuxDebCommand = `curl -L -O ${downloadBaseUrl}/beats/elastic-agent/elastic-agent-${agentVersion}-amd64.deb ${curlDownloadSourceProxyArgs}
sudo dpkg -i elastic-agent-${agentVersion}-amd64.deb
sudo systemctl enable elastic-agent \nsudo systemctl start elastic-agent \nsudo elastic-agent enroll ${enrollArgs} \n`;
  const linuxRpmCommand = `curl -L -O ${downloadBaseUrl}/beats/elastic-agent/elastic-agent-${agentVersion}-x86_64.rpm ${curlDownloadSourceProxyArgs}
sudo rpm -vi elastic-agent-${agentVersion}-x86_64.rpm
sudo systemctl enable elastic-agent \nsudo systemctl start elastic-agent \nsudo elastic-agent enroll ${enrollArgs} \n`;
  const googleCloudShellCommand = `gcloud config set project ${gcpProjectId} && ${gcpAccountType === 'organization-account' ? `ORG_ID=${gcpOrganizationId}` : ``} FLEET_URL=${fleetServerUrl === null || fleetServerUrl === void 0 ? void 0 : fleetServerUrl.trim()} ENROLLMENT_TOKEN=${enrollmentToken} STACK_VERSION=${agentVersion} ./deploy.sh`;
  return {
    linux: linuxCommand,
    mac: macCommand,
    windows: windowsCommand,
    deb: linuxDebCommand,
    rpm: linuxRpmCommand,
    kubernetes: k8sCommand,
    cloudFormation: '',
    googleCloudShell: googleCloudShellCommand
  };
};
exports.ManualInstructions = ManualInstructions;