"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBuildIntegrationsUrl = void 0;
var _reactRouterDom = require("react-router-dom");
var _hooks = require("../../../../../hooks");
var _ = require("..");
var _constants = require("../../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBuildIntegrationsUrl = () => {
  const {
    http
  } = (0, _hooks.useStartServices)();
  const addBasePath = http.basePath.prepend;
  const {
    selectedCategory: initialSelectedCategory,
    selectedSubcategory: initialSubcategory,
    searchParam
  } = (0, _.getParams)((0, _reactRouterDom.useParams)(), (0, _reactRouterDom.useLocation)().search);
  const {
    getHref,
    getAbsolutePath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const buildUrl = ({
    searchString,
    categoryId,
    subCategoryId
  }) => {
    const url = _constants.pagePathGetters.integrations_all({
      category: categoryId ? categoryId : '',
      subCategory: subCategoryId ? subCategoryId : '',
      searchTerm: searchString ? searchString : ''
    })[1];
    return url;
  };
  const setUrlandPushHistory = ({
    searchString,
    categoryId,
    subCategoryId
  }) => {
    const url = buildUrl({
      categoryId,
      searchString,
      subCategoryId
    });
    history.push(url);
  };
  const setUrlandReplaceHistory = ({
    searchString,
    categoryId,
    subCategoryId
  }) => {
    const url = buildUrl({
      categoryId,
      searchString,
      subCategoryId
    });
    // Use .replace so the browser's back button is not tied to single keystroke
    history.replace(url);
  };
  return {
    initialSelectedCategory,
    initialSubcategory,
    setUrlandPushHistory,
    setUrlandReplaceHistory,
    getHref,
    getAbsolutePath,
    searchParam,
    addBasePath
  };
};
exports.useBuildIntegrationsUrl = useBuildIntegrationsUrl;