"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Requirements = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Requirements = exports.Requirements = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.requirementsTitle",
    defaultMessage: "Requirements"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    listItems: [{
      title: _i18n.i18n.translate('xpack.fleet.epm.requirements.permissionLabel', {
        defaultMessage: 'Permissions'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.fleet.epm.requirements.permissionRequireRootTooltip', {
          defaultMessage: 'Elastic agent needs to be run with root or administrator privileges'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.requirements.permissionRequireRootMessage",
        defaultMessage: "{guideLink}",
        values: {
          guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.fleet.unprivilegedMode,
            target: "_blank",
            external: true
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.permissionRequireRootMessage.guideLink",
            defaultMessage: "Root privileges"
          }))
        }
      })))
    }]
  })));
});