"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconPanel = IconPanel;
exports.LoadingIconPanel = LoadingIconPanel;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _components = require("../../../../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Panel = (0, _styledComponents.default)(_eui.EuiPanel)`
  padding: ${props => props.theme.eui.euiSizeXL};
  width: ${props => parseFloat(props.theme.eui.euiSize) * 6 + parseFloat(props.theme.eui.euiSizeXL) * 2}px;
  svg,
  img {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    width: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
  }
  .euiFlexItem {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    justify-content: center;
  }
`;
function IconPanel({
  packageName,
  integrationName,
  version,
  icons
}) {
  const iconType = (0, _hooks.usePackageIconType)({
    packageName,
    integrationName,
    version,
    icons
  });
  return /*#__PURE__*/_react.default.createElement(Panel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "original"
  }));
}
function LoadingIconPanel() {
  return /*#__PURE__*/_react.default.createElement(Panel, null, /*#__PURE__*/_react.default.createElement(_components.Loading, null));
}