"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeferredAssetDescription = exports.DeferredTransformAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../../hooks");
var _constants = require("../../../constants");
var _types = require("../../../../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeferredAssetDescription = (assetType, assetCount, permissions) => {
  switch (assetType) {
    case _types.ElasticsearchAssetType.transform:
      if (permissions.canReauthorizeTransforms) {
        return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredTransformReauthorizeDescription', {
          defaultMessage: '{assetCount, plural, one {Transform was installed but requires} other {# transforms were installed but require}} additional permissions to run. Reauthorize the {assetCount, plural, one {transform} other {transforms}} to start operations.',
          values: {
            assetCount: assetCount !== null && assetCount !== void 0 ? assetCount : 1
          }
        });
      }
      return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredTransformRequestPermissionDescription', {
        defaultMessage: '{assetCount, plural, one {Transform was installed but requires} other {# transforms were installed but require}} additional permissions to run. Contact your administrator to request the required privileges.',
        values: {
          assetCount: assetCount !== null && assetCount !== void 0 ? assetCount : 1
        }
      });
    default:
      return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredInstallationsDescription', {
        defaultMessage: 'Asset requires additional permissions.'
      });
  }
};
exports.getDeferredAssetDescription = getDeferredAssetDescription;
const DeferredTransformAccordion = ({
  packageInfo,
  type,
  deferredInstallations,
  forceRefreshAssets
}) => {
  var _useAuthz$packagePriv, _useAuthz$packagePriv2, _useAuthz$packagePriv3, _useAuthz$packagePriv4, _useAuthz$packagePriv5;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const deferredTransforms = (0, _react.useMemo)(() => deferredInstallations.map(i => ({
    id: i.id,
    attributes: {
      title: i.id,
      description: i.type
    }
  })), [deferredInstallations]);
  const canReauthorizeTransforms = (_useAuthz$packagePriv = (_useAuthz$packagePriv2 = (0, _hooks.useAuthz)().packagePrivileges) === null || _useAuthz$packagePriv2 === void 0 ? void 0 : (_useAuthz$packagePriv3 = _useAuthz$packagePriv2.transform) === null || _useAuthz$packagePriv3 === void 0 ? void 0 : (_useAuthz$packagePriv4 = _useAuthz$packagePriv3.actions) === null || _useAuthz$packagePriv4 === void 0 ? void 0 : (_useAuthz$packagePriv5 = _useAuthz$packagePriv4.canStartStopTransform) === null || _useAuthz$packagePriv5 === void 0 ? void 0 : _useAuthz$packagePriv5.executePackageAction) !== null && _useAuthz$packagePriv !== void 0 ? _useAuthz$packagePriv : false;
  const authorizeTransforms = (0, _react.useCallback)(async transformIds => {
    setIsLoading(true);
    notifications.toasts.addInfo(_i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.authorizeTransformsAcknowledged', {
      defaultMessage: 'Request to authorize {count, plural, one {# transform} other {# transforms}} acknowledged.',
      values: {
        count: transformIds.length
      }
    }), {
      toastLifeTimeMs: 500
    });
    try {
      const reauthorizeTransformResp = await (0, _hooks.sendRequestReauthorizeTransforms)(packageInfo.name, packageInfo.version, transformIds);
      if (reauthorizeTransformResp.error) {
        throw reauthorizeTransformResp.error;
      }
      if (Array.isArray(reauthorizeTransformResp.data)) {
        var _reauthorizeTransform;
        const error = (_reauthorizeTransform = reauthorizeTransformResp.data.find(d => d.error)) === null || _reauthorizeTransform === void 0 ? void 0 : _reauthorizeTransform.error;
        const cntAuthorized = reauthorizeTransformResp.data.filter(d => d.success).length;
        if (error) {
          var _error$meta, _errorBody$error, _errorBody$error2;
          const errorBody = (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.body;
          const errorMsg = errorBody ? `${(_errorBody$error = errorBody.error) === null || _errorBody$error === void 0 ? void 0 : _errorBody$error.type}: ${(_errorBody$error2 = errorBody.error) === null || _errorBody$error2 === void 0 ? void 0 : _errorBody$error2.reason}` : `${error.message}`;
          notifications.toasts.addError({
            name: errorMsg,
            message: errorMsg
          }, {
            title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.authorizeTransformsUnsuccessful', {
              defaultMessage: 'Unable to authorize {cntUnauthorized, plural, one {# transform} other {# transforms}}.',
              values: {
                cntUnauthorized: transformIds.length - cntAuthorized
              }
            }),
            toastLifeTimeMs: 1000
          });
        } else {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.authorizeTransformsSuccessful', {
            defaultMessage: 'Successfully authorized {count, plural, one {# transform} other {# transforms}}.',
            values: {
              count: cntAuthorized
            }
          }), {
            toastLifeTimeMs: 1000
          });
          if (forceRefreshAssets) {
            forceRefreshAssets();
          }
        }
      }
    } catch (e) {
      if (e) {
        notifications.toasts.addError(e, {
          title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.unableToAuthorizeAllTransformsError', {
            defaultMessage: 'An error occurred authorizing and starting transforms.'
          })
        });
        if (forceRefreshAssets) {
          forceRefreshAssets();
        }
      }
    }
    setIsLoading(false);
  }, [notifications.toasts, packageInfo.name, packageInfo.version, forceRefreshAssets]);
  if (deferredTransforms.length === 0) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _constants.AssetTitleMap[type]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "accent",
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", null, deferredTransforms.length)))),
    id: type
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, getDeferredAssetDescription(type, deferredInstallations.length, {
    canReauthorizeTransforms
  }), ' '), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subject": `fleetAssetsReauthorizeAll`,
    disabled: !canReauthorizeTransforms,
    isLoading: isLoading,
    size: 'm',
    onClick: e => {
      e.preventDefault();
      authorizeTransforms(deferredTransforms.map(t => ({
        transformId: t.id
      })));
    },
    "aria-label": getDeferredAssetDescription(type, deferredInstallations.length, {
      canReauthorizeTransforms
    })
  }, _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.reauthorizeAllButton', {
    defaultMessage: 'Reauthorize all'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false
  }, deferredTransforms.map(({
    id: transformId
  }, idx) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: transformId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      grow: false,
      key: `${transformId}-${idx}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 8
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("p", null, transformId))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: canReauthorizeTransforms ? undefined : getDeferredAssetDescription(type, 1, {
        canReauthorizeTransforms
      }),
      "data-test-subject": `fleetAssetsReauthorizeTooltip-${transformId}-${isLoading}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isLoading,
      disabled: !canReauthorizeTransforms,
      size: 's',
      onClick: e => {
        e.preventDefault();
        authorizeTransforms([{
          transformId
        }]);
      }
    }, _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.reauthorizeButton', {
      defaultMessage: 'Reauthorize'
    })))))), idx + 1 < deferredTransforms.length && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }));
  }))));
};
exports.DeferredTransformAccordion = DeferredTransformAccordion;