"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexGroupWithMaxHeight = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-height: calc(100vh - 120px);
`;
const ControlsColumn = ({
  controls,
  title
}) => {
  let titleContent;
  if (title) {
    titleContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(FlexGroupWithMaxHeight, {
    direction: "column",
    gutterSize: "none"
  }, titleContent, controls);
};
exports.ControlsColumn = ControlsColumn;