"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultLayout = exports.DefaultLayout = /*#__PURE__*/(0, _react.memo)(({
  section,
  children,
  notificationsBySection
}) => {
  var _integrationAssistant;
  const {
    integrationAssistant
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const tabs = [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.integrationsAllLinkText",
      defaultMessage: "Browse integrations"
    }),
    section: 'browse',
    href: getHref('integrations_all')
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.integrationsInstalledLinkText",
      defaultMessage: "Installed integrations"
    }),
    section: 'manage',
    href: getHref('integrations_installed')
  }];
  const {
    CreateIntegrationCardButton
  } = (_integrationAssistant = integrationAssistant === null || integrationAssistant === void 0 ? void 0 : integrationAssistant.components) !== null && _integrationAssistant !== void 0 ? _integrationAssistant : {};
  return /*#__PURE__*/_react.default.createElement(_.WithHeaderLayout, {
    leftColumn: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationsHeaderTitle",
      defaultMessage: "Integrations"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.pageSubtitle",
      defaultMessage: "Choose an integration to start collecting and analyzing your data."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })),
    rightColumnGrow: false,
    rightColumn: CreateIntegrationCardButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(CreateIntegrationCardButton, null)) : undefined,
    tabs: tabs.map(tab => {
      const notificationCount = notificationsBySection === null || notificationsBySection === void 0 ? void 0 : notificationsBySection[tab.section];
      return {
        name: tab.name,
        append: notificationCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
          className: "eui-alignCenter",
          size: "m"
        }, notificationCount) : undefined,
        href: tab.href,
        isSelected: section === tab.section
      };
    })
  }, children);
});