"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentAndPolicyCountForOutput = getAgentAndPolicyCountForOutput;
var _hooks = require("../../../hooks");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAgentAndPolicyCountForOutput(output) {
  var _agentPolicies$data, _packagePolicies$data;
  let agentPolicyKuery = `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.data_output_id:"${output.id}" or ${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.monitoring_output_id:"${output.id}"`;
  const packagePolicyKuery = `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.output_id:"${output.id}"`;
  if (output.is_default) {
    agentPolicyKuery += ` or (not ${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.data_output_id:*)`;
  }
  const agentPolicies = await (0, _hooks.sendGetAgentPolicies)({
    kuery: agentPolicyKuery,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    noAgentCount: true
  });
  if (agentPolicies.error) {
    throw agentPolicies.error;
  }
  const packagePolicies = await (0, _hooks.sendGetPackagePolicies)({
    kuery: packagePolicyKuery,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT
  });
  if (packagePolicies.error) {
    throw agentPolicies.error;
  }
  const agentPolicyIds = (((_agentPolicies$data = agentPolicies.data) === null || _agentPolicies$data === void 0 ? void 0 : _agentPolicies$data.items) || []).map(policy => policy.id);
  const agentPolicyIdsFromPackagePolicies = (((_packagePolicies$data = packagePolicies.data) === null || _packagePolicies$data === void 0 ? void 0 : _packagePolicies$data.items) || []).reduce((acc, packagePolicy) => {
    return [...acc, ...(packagePolicy.policy_ids || [])];
  }, []);
  const uniqueAgentPolicyIds = new Set([...agentPolicyIds, ...agentPolicyIdsFromPackagePolicies]);
  const agentPolicyCount = uniqueAgentPolicyIds.size;
  let agentCount = 0;
  if (agentPolicyCount > 0) {
    var _agents$data$total, _agents$data;
    const agents = await (0, _hooks.sendGetAgents)({
      page: 1,
      perPage: 0,
      // We only need the count here
      showInactive: false,
      kuery: [...uniqueAgentPolicyIds].map(id => `policy_id:"${id}"`).join(' or ')
    });
    if (agents.error) {
      throw agents.error;
    }
    agentCount = (_agents$data$total = (_agents$data = agents.data) === null || _agents$data === void 0 ? void 0 : _agents$data.total) !== null && _agents$data$total !== void 0 ? _agents$data$total : 0;
  }
  return {
    agentPolicyCount,
    agentCount
  };
}