"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerCloudUnhealthyCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerCloudUnhealthyCallout = ({
  deploymentUrl
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerCloudUnhealthyCallout.calloutTitle",
      defaultMessage: "Fleet Server is not Healthy"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerCloudRequiredCallout.calloutDescription",
    defaultMessage: "A healthy Fleet server is required to enroll agents with Fleet. Enable Fleet Server in your {cloudDeploymentLink}. For more information see the {guideLink}.",
    values: {
      cloudDeploymentLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: deploymentUrl,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerCloudRequiredCallout.cloudDeploymentLink",
        defaultMessage: "cloud deployment"
      })),
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.fleetServerAddFleetServer,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerCloudRequiredCallout.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: deploymentUrl,
    target: "_blank",
    color: "warning",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerCloudRequiredCallout.editDeploymentButtonLabel",
    defaultMessage: "Edit deployment"
  })));
};
exports.FleetServerCloudUnhealthyCallout = FleetServerCloudUnhealthyCallout;