"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DonutChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _d = _interopRequireDefault(require("d3"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DonutChart = ({
  height,
  width,
  data
}) => {
  const chartElement = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (chartElement.current !== null) {
      // we must remove any existing paths before painting
      _d.default.selectAll('g').remove();
      const svgElement = _d.default.select(chartElement.current).append('g').attr('transform', `translate(${width / 2}, ${height / 2})`);
      const color = _d.default.scale.ordinal()
      // @ts-ignore
      .domain(data).range(['#017D73', '#98A2B3', '#BD271E', '#F5A700']);
      const pieGenerator = _d.default.layout.pie().value(({
        value
      }) => value)
      // these start/end angles will reverse the direction of the pie,
      // which matches our design
      .startAngle(2 * Math.PI).endAngle(0);
      svgElement.selectAll('g')
      // @ts-ignore
      .data(pieGenerator(_d.default.entries(data))).enter().append('path').attr('d',
      // @ts-ignore attr does not expect a param of type Arc<Arc> but it behaves as desired
      _d.default.svg.arc().innerRadius(width * 0.36).outerRadius(Math.min(width, height) / 2)).attr('fill', d => color(d.data.key));
    }
  }, [data, height, width]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("svg", {
    ref: chartElement,
    width: width,
    height: height
  }));
};
exports.DonutChart = DonutChart;