"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// polyfill until https://github.com/elastic/eui/discussions/5836 implemented
const NumberlessHorizontalSteps = (0, _styledComponents.default)(_eui.EuiStepsHorizontal)`
  .euiStepNumber {
    color: transparent;
    width: 16px;
    height: 16px;
    outline-color: #07c;
  }
  .euiStepHorizontal::before {
    width: calc(50% - 8px);
    top: 32px;
  }
  .euiStepHorizontal::after {
    width: calc(50% - 8px);
    top: 32px;
  }
  .euiStepHorizontal {
    padding: 25px 16px 16px;
  }
  .euiStepHorizontal[data-step-status='incomplete'] .euiStepHorizontal__title {
    color: #69707d;
  }
`;
const getStepStatus = (currentStep, stepIndex, currentStepComplete) => {
  if (currentStep === stepIndex) {
    if (currentStepComplete) return 'complete';
    return 'current';
  }
  if (currentStep > stepIndex) {
    return 'complete';
  }
  return 'incomplete';
};
const PageSteps = ({
  steps: stepTitles,
  currentStep = 0,
  currentStepComplete = false
}) => {
  const steps = stepTitles.map((title, index) => {
    return {
      title,
      status: getStepStatus(currentStep, index, currentStepComplete),
      onClick: () => {}
    };
  });
  return /*#__PURE__*/_react.default.createElement(NumberlessHorizontalSteps, {
    steps: steps
  });
};
exports.PageSteps = PageSteps;