"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepConfigurePackagePolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../../common/services");
var _components = require("../../../../../components");
var _services2 = require("../../../../../services");
var _constants = require("../../../../../../../../common/constants");
var _components2 = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepConfigurePackagePolicy = ({
  packageInfo,
  showOnlyIntegration,
  packagePolicy,
  updatePackagePolicy,
  validationResults,
  submitAttempted,
  noTopRule = false,
  isEditPage = false,
  isAgentlessSelected = false
}) => {
  const hasIntegrations = (0, _react.useMemo)(() => (0, _services2.doesPackageHaveIntegrations)(packageInfo), [packageInfo]);
  const packagePolicyTemplates = (0, _react.useMemo)(() => showOnlyIntegration ? (packageInfo.policy_templates || []).filter(policyTemplate => policyTemplate.name === showOnlyIntegration) : packageInfo.policy_templates || [], [packageInfo.policy_templates, showOnlyIntegration]);
  // Configure inputs (and their streams)
  const renderConfigureInputs = () => packagePolicyTemplates.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !noTopRule && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, packagePolicyTemplates.map(policyTemplate => {
    const inputs = (0, _services.getNormalizedInputs)(policyTemplate);
    const packagePolicyInputs = packagePolicy.inputs;
    return inputs.map(packageInput => {
      var _validationResults$in, _validationResults$in2;
      const packagePolicyInput = packagePolicyInputs.find(input => input.type === packageInput.type && (hasIntegrations ? input.policy_template === policyTemplate.name : true));
      const packageInputStreams = (0, _services.getRegistryStreamWithDataStreamForInputType)(packageInput.type, packageInfo, hasIntegrations && (0, _services.isIntegrationPolicyTemplate)(policyTemplate) ? policyTemplate.data_streams : []);
      const updatePackagePolicyInput = updatedInput => {
        const indexOfUpdatedInput = packagePolicyInputs.findIndex(input => input.type === packageInput.type && (hasIntegrations ? input.policy_template === policyTemplate.name : true));
        const newInputs = [...packagePolicyInputs];
        newInputs[indexOfUpdatedInput] = {
          ...newInputs[indexOfUpdatedInput],
          ...updatedInput
        };
        updatePackagePolicy({
          inputs: newInputs
        });
      };
      return packagePolicyInput && !((isAgentlessSelected || packagePolicy.supports_agentless === true) && _constants.AGENTLESS_DISABLED_INPUTS.includes(packagePolicyInput.type)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: packageInput.type
      }, /*#__PURE__*/_react.default.createElement(_components2.PackagePolicyInputPanel, {
        packageInput: packageInput,
        packageInfo: packageInfo,
        packageInputStreams: packageInputStreams,
        packagePolicyInput: packagePolicyInput,
        updatePackagePolicyInput: updatePackagePolicyInput,
        inputValidationResults: (_validationResults$in = validationResults === null || validationResults === void 0 ? void 0 : (_validationResults$in2 = validationResults.inputs) === null || _validationResults$in2 === void 0 ? void 0 : _validationResults$in2[hasIntegrations ? `${policyTemplate.name}-${packagePolicyInput.type}` : packagePolicyInput.type]) !== null && _validationResults$in !== void 0 ? _validationResults$in : {},
        forceShowErrors: submitAttempted,
        isEditPage: isEditPage
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "m"
      })) : null;
    });
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "checkInCircleFilled",
    iconColor: "success",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.noPolicyOptionsMessage",
      defaultMessage: "Nothing to configure"
    })))
  });
  return validationResults ? renderConfigureInputs() : /*#__PURE__*/_react.default.createElement(_components.Loading, null);
};
exports.StepConfigurePackagePolicy = StepConfigurePackagePolicy;