"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("./hooks");
var _use_latest_fleet_servers = require("./hooks/use_latest_fleet_servers");
var _steps = require("./steps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedTab = ({
  selectedPolicyId,
  onClose
}) => {
  var _fleetServerHostForm$;
  const {
    isSelectFleetServerPolicyLoading,
    eligibleFleetServerPolicies,
    refreshEligibleFleetServerPolicies,
    fleetServerPolicyId,
    setFleetServerPolicyId,
    isFleetServerReady,
    serviceToken,
    isLoadingServiceToken,
    generateServiceToken,
    fleetServerHostForm,
    deploymentMode,
    setDeploymentMode
  } = (0, _hooks.useAdvancedForm)();
  const {
    hasRecentlyEnrolledFleetServers
  } = (0, _use_latest_fleet_servers.useLatestFleetServers)();
  const steps = [(0, _steps.getSelectAgentPolicyStep)({
    policyId: fleetServerPolicyId || selectedPolicyId,
    setPolicyId: setFleetServerPolicyId,
    eligibleFleetServerPolicies,
    refreshEligibleFleetServerPolicies
  }), (0, _steps.getSetDeploymentModeStep)({
    deploymentMode,
    setDeploymentMode,
    disabled: !Boolean(fleetServerPolicyId || selectedPolicyId)
  }), (0, _steps.getAddFleetServerHostStep)({
    fleetServerHostForm,
    disabled: !Boolean(fleetServerPolicyId || selectedPolicyId),
    onClose
  }), (0, _steps.getGenerateServiceTokenStep)({
    serviceToken,
    generateServiceToken,
    isLoadingServiceToken,
    disabled: Boolean(!fleetServerHostForm.fleetServerHost) || !Boolean(fleetServerPolicyId || selectedPolicyId)
  }), (0, _steps.getInstallFleetServerStep)({
    isFleetServerReady,
    serviceToken,
    fleetServerHost: (_fleetServerHostForm$ = fleetServerHostForm.fleetServerHost) === null || _fleetServerHostForm$ === void 0 ? void 0 : _fleetServerHostForm$.host_urls[0],
    fleetServerPolicyId: fleetServerPolicyId || selectedPolicyId,
    deploymentMode,
    disabled: !Boolean(serviceToken)
  }), (0, _steps.getConfirmFleetServerConnectionStep)({
    hasRecentlyEnrolledFleetServers,
    disabled: !Boolean(serviceToken)
  })];
  return isSelectFleetServerPolicyLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    className: "eui-textLeft"
  });
};
exports.AdvancedTab = AdvancedTab;