"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function validate(command, references, ast) {
  const messages = [];
  if (!isRrfImmediatelyAfterFork(ast)) {
    messages.push({
      location: command.location,
      text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.validation.rrfMissingScoreMetadata', {
        defaultMessage: '[RRF] Must be immediately preceded by a FORK command.'
      }),
      type: 'error',
      code: 'rrfNotImmediatelyAfterFork'
    });
  }
  if (!references.fields.get('_id')) {
    messages.push(buildMissingMetadataMessage(command, '_id'));
  }
  if (!references.fields.get('_index')) {
    messages.push(buildMissingMetadataMessage(command, '_index'));
  }
  if (!references.fields.get('_score')) {
    messages.push(buildMissingMetadataMessage(command, '_score'));
  }
  return messages;
}
function buildMissingMetadataMessage(command, metadataField) {
  return {
    location: command.location,
    text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.validation.rrfMissingMetadata', {
      defaultMessage: `[RRF] The FROM command is missing the {metadataField} METADATA field.`,
      values: {
        metadataField
      }
    }),
    type: 'error',
    code: `rrfMissingMetadata`
  };
}
function isRrfImmediatelyAfterFork(ast) {
  const forkIndex = ast.findIndex(cmd => cmd.name === 'fork');
  const rrfIndex = ast.findIndex(cmd => cmd.name === 'rrf');
  return forkIndex !== -1 && rrfIndex === forkIndex + 1;
}