"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _i18n = require("@kbn/i18n");
var _ = require("../../../..");
var _esql_types = require("../../../shared/esql_types");
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  command,
  getColumnsByType,
  innerText
}) {
  const commandArgs = command.args.filter(arg => (0, _.isSingleItem)(arg) && arg.type !== 'unknown');

  // GROK field /
  if (commandArgs.length === 1 && /\s$/.test(innerText)) {
    return (0, _factories.buildConstantsDefinitions)(['"%{WORD:firstWord}"'], _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.aPatternString', {
      defaultMessage: 'A pattern string'
    }), undefined, {
      advanceCursorAndOpenSuggestions: true
    });
  }
  // GROK field pattern /
  else if (commandArgs.length === 2) {
    return [{
      ..._complete_items.pipeCompleteItem,
      command: _factories.TRIGGER_SUGGESTION_COMMAND
    }];
  }

  // GROK /
  const fieldSuggestions = await getColumnsByType(_esql_types.ESQL_STRING_TYPES);
  return fieldSuggestions.map(sug => ({
    ...sug,
    text: `${sug.text} `,
    command: _factories.TRIGGER_SUGGESTION_COMMAND
  }));
}