"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWhereCommand = void 0;
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createWhereCommand = ctx => {
  const command = (0, _factories.createCommand)('where', ctx);
  const expressions = (0, _walkers.collectBooleanExpression)(ctx.booleanExpression());
  command.args.push(expressions[0]);
  return command;
};
exports.createWhereCommand = createWhereCommand;