"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setQuery = exports.setInferenceId = exports.setFields = exports.list = void 0;
var _builder = require("../../../builder");
var generic = _interopRequireWildcard(require("../../generic"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Lists all "RERANK" commands in the query AST.
 *
 * @param ast The root AST node to search for "RERANK" commands.
 * @returns A collection of "RERANK" commands.
 */
const list = ast => {
  return generic.commands.list(ast, cmd => cmd.name === 'rerank');
};
exports.list = list;
const setQuery = (cmd, query) => {
  if (typeof query === 'string') {
    query = _builder.Builder.expression.literal.string(query);
  }
  cmd.query = query;
  cmd.args[0] = query;
};
exports.setQuery = setQuery;
const setFields = (cmd, fields) => {
  if (typeof fields[0] === 'string') {
    fields = fields.map(fieldOrFieldName => {
      return typeof fieldOrFieldName === 'string' ? _builder.Builder.expression.column(fieldOrFieldName) : fieldOrFieldName;
    });
  }
  cmd.fields.length = 0;
  cmd.fields.push(...fields);
};
exports.setFields = setFields;
const setInferenceId = (cmd, id) => {
  if (typeof id === 'string') {
    id = id[0] === '?' ? _builder.Builder.param.build(id) : _builder.Builder.identifier(id);
  }
  if (id.type !== 'identifier' && id.type !== 'literal') {
    throw new Error(`Invalid RERANK inferenceId: ${id}`);
  }
  cmd.inferenceId = id;
  const withOption = cmd.args[2];
  withOption.args[0] = id;
};
exports.setInferenceId = setInferenceId;